#ifndef _graphcjj1L_STATE_H
#define _graphcjj1L_STATE_H

#include "graphcjj1L_macros.h"
#include "include/learning/perceptron/score.h"

namespace graphcjj1L {
	enum STATE{
		L2R_LABEL = 1,
		L2R_NOLABEL,
	};

	class StateItem {
	public:
		int type;
		int left, right;
		ScoreWithSplit l2r_label, l2r_nolabel;

	public:

		StateItem();
		~StateItem();

		void init(const int & l, const int & r);

		void updateL2R_LABEL(const int & split, const tscore & score , const int & label = 0);
		void updateL2R_NOLABEL(const int & split, const tscore & score , const int & label = 0);

		void print();
	};

	inline void StateItem::updateL2R_LABEL(const int & split, const tscore & score , const int & label) {
		if (l2r_label < score) {
			l2r_label.refer(split, score,label);
		}
	}

	inline void StateItem::updateL2R_NOLABEL(const int & split, const tscore & score, const int & label) {
		if (l2r_nolabel < score) {
			l2r_nolabel.refer(split, score,label);
		}
	}

	
}

#endif
