/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.modification.costsensitive;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import matetools.is2.data.Cluster;
import matetools.is2.data.DataFES;
import matetools.is2.data.F2SF;
import matetools.is2.data.Instances;
import matetools.is2.data.Parse;
import matetools.is2.data.PipeGen;
import matetools.is2.data.SentenceData09;
import matetools.is2.io.CONLLReader09;
import matetools.is2.modification.costsensitive.CostSensitiveExtractor;
import matetools.is2.modification.io.CONLLReader08;
import matetools.is2.parser.Edges;
import matetools.is2.parser.MFO;
import matetools.is2.parser.ParallelExtract;
import matetools.is2.parser.Parser;
import matetools.is2.util.OptionsSuper;

public class Pipe
extends PipeGen {
    public CostSensitiveExtractor[] extractor;
    public final MFO mf = new MFO();
    public Cluster cl;
    protected OptionsSuper options;
    public static long timeExtract;
    public static ExecutorService executerService;

    static {
        executerService = Executors.newFixedThreadPool(Parser.THREADS);
    }

    public Pipe(OptionsSuper o) {
        this.options = o;
    }

    public void createInstances(String mainTrain, String additionalTrain, Instances is) throws Exception {
        int k;
        short[] pos;
        int last;
        SentenceData09 instance1;
        int i2;
        int i1;
        String[] w;
        String[] labs1;
        SentenceData09 instance;
        CONLLReader09 depReader = this.options.formatTask == 9 ? new CONLLReader09(mainTrain) : new CONLLReader08(mainTrain);
        CONLLReader09 additionalDepReader = null;
        if (additionalTrain != null) {
            additionalDepReader = this.options.formatTask == 9 ? new CONLLReader09(additionalTrain) : new CONLLReader08(additionalTrain);
        }
        this.mf.register("REL", "<root-type>");
        long sl = 0L;
        System.out.print("Registering feature parts of sentence: ");
        int ic = 0;
        int del = 0;
        while ((instance = depReader.getNext()) != null) {
            sl += (long)instance.labels.length;
            if (++ic % 1000 == 0) {
                del = Pipe.outValue(ic, del);
            }
            labs1 = instance.labels;
            int i12 = 0;
            while (i12 < labs1.length) {
                this.mf.register("REL", labs1[i12]);
                ++i12;
            }
            w = instance.forms;
            int i13 = 0;
            while (i13 < w.length) {
                this.mf.register("WORD", depReader.normalize(w[i13]));
                ++i13;
            }
            w = instance.plemmas;
            i13 = 0;
            while (i13 < w.length) {
                this.mf.register("WORD", depReader.normalize(w[i13]));
                ++i13;
            }
            w = instance.ppos;
            i13 = 0;
            while (i13 < w.length) {
                this.mf.register("POS", w[i13]);
                ++i13;
            }
            w = instance.gpos;
            i13 = 0;
            while (i13 < w.length) {
                this.mf.register("POS", w[i13]);
                ++i13;
            }
            if (instance.feats != null) {
                String[][] fs = instance.feats;
                i1 = 0;
                while (i1 < fs.length) {
                    w = fs[i1];
                    if (w != null) {
                        i2 = 0;
                        while (i2 < w.length) {
                            this.mf.register("F", w[i2]);
                            ++i2;
                        }
                    }
                    ++i1;
                }
            }
            if (ic - 1 <= this.options.count) continue;
        }
        while (additionalDepReader != null) {
            instance = additionalDepReader.getNext();
            if (instance == null) break;
            sl += (long)instance.labels.length;
            if (++ic % 1000 == 0) {
                del = Pipe.outValue(ic, del);
            }
            labs1 = instance.labels;
            int i14 = 0;
            while (i14 < labs1.length) {
                this.mf.register("REL", labs1[i14]);
                ++i14;
            }
            w = instance.forms;
            int i15 = 0;
            while (i15 < w.length) {
                this.mf.register("WORD", depReader.normalize(w[i15]));
                ++i15;
            }
            w = instance.plemmas;
            i15 = 0;
            while (i15 < w.length) {
                this.mf.register("WORD", depReader.normalize(w[i15]));
                ++i15;
            }
            w = instance.ppos;
            i15 = 0;
            while (i15 < w.length) {
                this.mf.register("POS", w[i15]);
                ++i15;
            }
            w = instance.gpos;
            i15 = 0;
            while (i15 < w.length) {
                this.mf.register("POS", w[i15]);
                ++i15;
            }
            if (instance.feats != null) {
                String[][] fs = instance.feats;
                i1 = 0;
                while (i1 < fs.length) {
                    w = fs[i1];
                    if (w != null) {
                        i2 = 0;
                        while (i2 < w.length) {
                            this.mf.register("F", w[i2]);
                            ++i2;
                        }
                    }
                    ++i1;
                }
            }
            if (ic - 1 > this.options.count) break;
        }
        del = Pipe.outValue(ic, del);
        System.out.println();
        CostSensitiveExtractor.initFeatures();
        CostSensitiveExtractor.maxForm = this.mf.getFeatureCounter().get("WORD");
        this.cl = this.options.clusterFile == null ? new Cluster() : new Cluster(this.options.clusterFile, this.mf, 6);
        this.mf.calculateBits();
        CostSensitiveExtractor.initStat(this.options.featureCreation);
        System.out.println(this.mf.toString());
        CostSensitiveExtractor[] fs = this.extractor;
        int w2 = this.extractor.length;
        int labs12 = 0;
        while (labs12 < w2) {
            CostSensitiveExtractor e = fs[labs12];
            e.init();
            ++labs12;
        }
        depReader.startReading(mainTrain);
        int num1 = 0;
        is.init(ic, new MFO());
        Edges.init(this.mf.getFeatureCounter().get("POS"));
        System.out.print("Creating edge filters and read corpus: ");
        del = 0;
        while (true) {
            if (num1 % 100 == 0) {
                del = Pipe.outValue(num1, del);
            }
            if ((instance1 = depReader.getNext(is)) == null) break;
            last = is.size() - 1;
            is.gstrpos[last] = instance1.gpos;
            pos = is.pposs[last];
            k = 0;
            while (k < is.length(last)) {
                if (is.heads[last][k] >= 0) {
                    Edges.put(pos[is.heads[last][k]], pos[k], is.labels[last][k]);
                }
                ++k;
            }
            if (!this.options.allFeatures && num1 > this.options.count) break;
            ++num1;
        }
        if (additionalDepReader != null) {
            additionalDepReader.startReading(additionalTrain);
            while (true) {
                if (num1 % 100 == 0) {
                    del = Pipe.outValue(num1, del);
                }
                if ((instance1 = additionalDepReader.getNext(is)) == null) break;
                last = is.size() - 1;
                is.additional[last] = true;
                is.gstrpos[last] = instance1.gpos;
                pos = is.pposs[last];
                k = 0;
                while (k < is.length(last)) {
                    if (is.heads[last][k] >= 0) {
                        Edges.put(pos[is.heads[last][k]], pos[k], is.labels[last][k]);
                    }
                    ++k;
                }
                if (!this.options.allFeatures && num1 > this.options.count) break;
                ++num1;
            }
        }
        del = Pipe.outValue(num1, del);
        System.out.println();
        Edges.findDefault();
    }

    protected final SentenceData09 nextInstance(Instances is, CONLLReader09 depReader) throws Exception {
        SentenceData09 instance = depReader.getNext(is);
        if (instance == null || instance.forms == null) {
            return null;
        }
        return instance;
    }

    public DataFES fillVector(F2SF params, Instances is, int inst, DataFES d, Cluster cluster) throws InterruptedException {
        long ts = System.nanoTime();
        if (executerService.isShutdown()) {
            executerService = Executors.newCachedThreadPool();
        }
        int length = is.length(inst);
        if (d == null || d.len < length) {
            d = new DataFES(length, this.mf.getFeatureCounter().get("REL").shortValue());
        }
        ArrayList<ParallelExtract> pe = new ArrayList<ParallelExtract>();
        int i = 0;
        while (i < Parser.THREADS) {
            pe.add(new ParallelExtract(this.extractor[i], is, inst, d, (F2SF)params.clone(), cluster));
            ++i;
        }
        int w1 = 0;
        while (w1 < length) {
            int w2 = w1 + 1;
            while (w2 < length) {
                if (w1 != w2) {
                    ParallelExtract.add(w1, w2);
                }
                ++w2;
            }
            ++w1;
        }
        executerService.invokeAll(pe);
        timeExtract += System.nanoTime() - ts;
        return d;
    }

    public double errors(Instances is, int ic, Parse p) {
        short[] act = is.heads[ic];
        double correct = 0.0;
        int i = 1;
        while (i < act.length) {
            if (p.heads[i] == act[i]) {
                correct += 0.5;
                if (p.labels[i] == is.labels[ic][i]) {
                    correct += 0.5;
                }
            }
            ++i;
        }
        double x = (double)act.length - 1.0 - correct;
        p.f1 = correct / (double)(act.length - 1);
        return x;
    }
}

