/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.data;

import matetools.is2.data.Long2IntInterface;
import matetools.is2.util.DB;

public class RandomIndex
implements Long2IntInterface {
    final int[] prims = new int[]{52349171, 199951347, 89990, 5001, 32891, 17, 19, 23, 29, 31, 37, 47, 53, 59, 61, 67, 71};
    final long[] hashFunctionModifiers;
    final int kbit;
    final int lbit;
    final int hsize;
    final int bits;
    final int moves;

    public RandomIndex(int kbit, int lbit, int hsize, int numberFunctions) {
        this.kbit = kbit;
        this.lbit = lbit;
        this.hsize = hsize <= 0 ? 67000001 : hsize;
        this.bits = (int)Math.ceil(Math.log(this.hsize) / Math.log(2.0));
        this.moves = (int)Math.ceil(64.0f / (float)this.bits);
        DB.println("moves " + this.moves + " bits " + this.bits + " hsize " + hsize);
        this.hashFunctionModifiers = new long[numberFunctions];
        int f = 0;
        while (f < numberFunctions) {
            this.hashFunctionModifiers[f] = this.prims[f];
            ++f;
        }
    }

    public int[] hash(long x) {
        int[] hvals = new int[this.hashFunctionModifiers.length];
        int k = 0;
        while (k < this.hashFunctionModifiers.length) {
            long value = (x + 1L) * this.hashFunctionModifiers[k];
            int j = 1;
            while (j <= this.moves) {
                value ^= value >> this.bits * j;
                ++j;
            }
            hvals[k] = Math.abs((int)value % this.hsize);
            ++k;
        }
        return hvals;
    }

    public int[] hashU(long x) {
        int[] hvals = new int[this.hashFunctionModifiers.length];
        long y = Long.reverse(x);
        int k = 0;
        while (k < this.hashFunctionModifiers.length) {
            long value1 = (y + 1L) * this.hashFunctionModifiers[k] >> this.kbit - this.lbit;
            hvals[k] = Math.abs((int)value1);
            ++k;
        }
        return hvals;
    }

    @Override
    public int l2i(long l) {
        return 0;
    }

    @Override
    public int size() {
        return this.hsize;
    }
}

