/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.data;

import java.util.ArrayList;
import java.util.Collections;
import matetools.is2.data.SentenceData09;
import matetools.is2.util.DB;

public class PSTree {
    int wordCount = 0;
    public String[] entries;
    public String[] lemmas;
    public int[] head;
    public String[] pos;
    public int[] ok;
    public int non;
    public int terminalCount;
    public String[] morph;
    public int[] forms;
    public int[] phrases;
    public int[][] psfeats;
    public int[] ppos;
    public static final boolean INSERT_NEWLINE = true;
    static int cnt = 0;

    public PSTree(SentenceData09 d) {
        this.create(d.length() - 1, d.length() * 20);
        int i = 1;
        while (i < d.length()) {
            this.entries[i - 1] = d.forms[i];
            this.pos[i - 1] = d.ppos[i];
            ++i;
        }
    }

    public PSTree() {
    }

    public void create(int terminals, int nonTerminals) {
        this.entries = new String[terminals + nonTerminals];
        this.pos = new String[terminals + nonTerminals];
        this.head = new int[terminals + nonTerminals];
        this.lemmas = new String[terminals + nonTerminals];
        this.morph = new String[terminals + nonTerminals];
        this.non = terminals;
        this.wordCount = terminals;
        int i = terminals + 1;
        while (i < this.head.length) {
            this.head[i] = -1;
            ++i;
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.entries.length) {
            if (this.head[i] == -1 && this.entries[i] == null) break;
            s.append(String.valueOf(i) + "\t" + this.pos[i] + "\t" + this.entries[i] + "\t" + this.head[i] + (this.ok == null ? "" : "\t" + (this.ok[i] == 1)) + " \n");
            ++i;
        }
        return s.toString();
    }

    public boolean containsNull() {
        int k = 0;
        while (k < this.wordCount - 1) {
            if (this.entries[k] == null) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public int equals(SentenceData09 s) {
        int j = 1;
        int i = 0;
        while (i < this.terminalCount - 1) {
            if (s.forms.length < j) {
                DB.println(s + " " + this.toString());
                return i;
            }
            if (!this.entries[i].equals(s.forms[j])) {
                if (this.entries[i].startsWith(s.forms[j]) && s.forms.length > i + 2 && s.forms[j + 1].equals("-")) {
                    if (this.entries[i].contains(s.forms[(j += 2) - 1]) && s.forms.length > i + 3 && s.forms[j + 1].equals("-") && this.entries[i].contains(s.forms[(j += 2) - 1]) && s.forms.length > i + 3 && s.forms[j + 1].equals("-")) {
                        j += 2;
                    }
                } else if (this.entries[i].startsWith(s.forms[j]) && s.forms.length > i + 2 && s.forms[j + 1].equals("/")) {
                    if (this.entries[i].contains(s.forms[(j += 2) - 1]) && s.forms.length > i + 3 && s.forms[j + 1].equals("/")) {
                        j += 2;
                    }
                } else if (this.entries[i].startsWith(s.forms[j]) && s.forms.length > i + 2 && s.forms[j + 1].equals(".")) {
                    if (this.entries[i].contains(s.forms[(j += 2) - 1]) && s.forms.length > i + 3 && s.forms[j + 1].equals(".")) {
                        j += 2;
                    }
                } else if (this.entries[i].startsWith(s.forms[j]) && s.forms.length > i + 1 && s.forms[j + 1].equals("'S")) {
                    ++j;
                } else {
                    return j;
                }
            }
            ++j;
            ++i;
        }
        return s.length();
    }

    public int getPS(int dn) {
        return this.head[dn - 1];
    }

    public String getChain(int dn, int n, int commonHead) {
        int pdn = dn - 1;
        int pdh = n - 1;
        int[] ch = new int[20];
        int head = this.head[pdn];
        int i = 0;
        ch[i++] = head;
        while (commonHead != head && head != 0) {
            head = this.head[head];
            ch[i++] = head;
        }
        StringBuffer chain = new StringBuffer();
        int k = 0;
        while (k < i) {
            chain.append(this.entries[ch[k]]).append(" ");
            ++k;
        }
        return chain.toString();
    }

    public int getCommonHead(int d, int dh) {
        int pdh = this.getPS(dh);
        int pd = this.getPS(d);
        ArrayList<Integer> path2root = this.getPath2Root(pdh);
        for (int n : path2root) {
            int candidateHead = pd;
            while (candidateHead != 0 && candidateHead != -1) {
                if (n == candidateHead) {
                    return n;
                }
                candidateHead = this.head[candidateHead];
            }
        }
        return -1;
    }

    private ArrayList<Integer> getPath2Root(int pdh) {
        ArrayList<Integer> path = new ArrayList<Integer>();
        int k = 0;
        while (k < 100) {
            if (pdh == -1) break;
            path.add(pdh);
            pdh = this.head[pdh];
            if (pdh == 0) break;
            ++k;
        }
        return path;
    }

    public String getOperationRoot(int pr) {
        StringBuffer o = new StringBuffer();
        int h = pr;
        int[] path = new int[10];
        int k = 0;
        while (k < 10) {
            if ((h = this.head[h]) == -1) break;
            path[k] = h;
            if (h == 0) break;
            ++k;
        }
        k -= 2;
        boolean first = true;
        while (k >= 0) {
            if (first) {
                o.append("c:").append(this.entries[path[k]]);
                first = false;
            } else {
                o.append(":ci:").append(this.entries[path[k]]);
            }
            --k;
        }
        o.append(":in:d");
        return o.toString();
    }

    public String getOperation(int dn, int n, int commonHead) {
        StringBuffer o = new StringBuffer();
        int ph = n - 1;
        int pd = dn - 1;
        int[] path = new int[20];
        boolean i = false;
        int h = ph;
        boolean nth = false;
        int k = 0;
        while (k < 10) {
            path[k] = h = this.head[h];
            if (nth) {
                o.append(':');
            }
            o.append("up:" + this.entries[h]);
            nth = true;
            if (h == commonHead) break;
            ++k;
        }
        k = 0;
        h = pd;
        while (k < 10) {
            path[k] = h = this.head[h];
            if (h == commonHead) break;
            ++k;
        }
        --k;
        while (k >= 0) {
            if (!nth) {
                o.append("ci:").append(this.entries[path[k]]);
                nth = true;
            } else {
                o.append(":ci:").append(this.entries[path[k]]);
            }
            --k;
        }
        o.append(":in:d");
        return o.toString();
    }

    public boolean exec(String r, int ph, int pt, boolean check) {
        String[] o = r.split(":");
        int last = -1;
        int headP = -1;
        boolean done = true;
        int i = 0;
        while (i < o.length) {
            if (o[i].equals("c")) {
                if (check) {
                    return true;
                }
                if (ph < 0) {
                    last = this.non++;
                }
                this.entries[this.non] = o[++i];
                this.head[pt] = this.non;
                this.head[this.non] = last;
                ++this.non;
            } else if (o[i].equals("ci")) {
                if (check) {
                    return true;
                }
                this.entries[this.non] = o[++i];
                this.head[this.non] = last;
                last = this.non++;
            } else if (o[i].equals("in") && o[i + 1].equals("d")) {
                if (check) {
                    return true;
                }
                this.head[pt] = last;
                ++i;
            } else if (o[i].equals("up")) {
                if (ph == -1) {
                    return false;
                }
                headP = headP == -1 ? this.head[ph] : this.head[headP];
                try {
                    if (headP == -1 || this.entries[headP] == null || !this.entries[headP].equals(o[i + 1])) {
                        return false;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(this.entries[headP] + " o[i+1] " + o[i + 1] + " " + headP + " " + this.terminalCount);
                    System.exit(0);
                }
                ++i;
                last = headP;
            } else {
                done = false;
            }
            ++i;
        }
        return done;
    }

    public boolean execT(String r, int ph, int pt, boolean check) {
        String[] o = r.split(":");
        int last = -1;
        int headP = -1;
        int up = 0;
        boolean done = true;
        int i = 0;
        while (i < o.length) {
            if (o[i].equals("c")) {
                if (check) {
                    return true;
                }
                if (ph < 0) {
                    last = this.non++;
                }
                this.entries[this.non] = o[++i];
                this.head[pt] = this.non;
                this.head[this.non] = last;
                ++this.non;
            } else if (o[i].equals("ci")) {
                if (check) {
                    return true;
                }
                this.entries[this.non] = o[++i];
                this.head[this.non] = last;
                last = this.non++;
            } else if (o[i].equals("in") && o[i + 1].equals("d")) {
                if (check) {
                    return true;
                }
                if (last != -1) {
                    this.head[pt] = last;
                }
                ++i;
            } else if (o[i].equals("up")) {
                ++up;
                if (ph == -1) {
                    return false;
                }
                headP = headP == -1 ? this.head[ph] : this.head[headP];
                try {
                    if (headP == -1 || this.entries[headP] == null || !this.entries[headP].equals(o[i + 1]) && up > 1) {
                        return false;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(this.entries[headP] + " o[i+1] " + o[i + 1] + " " + headP + " " + this.terminalCount);
                }
                ++i;
                last = headP;
            } else {
                done = false;
            }
            ++i;
        }
        return done;
    }

    public String toPennBracket(boolean newLine) {
        StringBuffer b = new StringBuffer();
        ArrayList<Integer> current = null;
        int open = 0;
        int i = 0;
        while (i < this.terminalCount) {
            String ps;
            ArrayList<Integer> path = this.getPathToRoot(i);
            ArrayList<Integer> diff = this.getDiffPath(path, current);
            boolean spaces = false;
            ArrayList<Integer> common = this.getDiffCommon(path, current);
            if (current != null && current.size() > common.size()) {
                int bc = 0;
                while (bc < current.size() - common.size()) {
                    b.append(")");
                    --open;
                    ++bc;
                }
                if (diff.size() == 0 && newLine) {
                    b.append("\n");
                }
                spaces = true;
            }
            if (i != 0 && diff.size() > 0 && newLine) {
                b.append("\n").append(this.createSpaces(open));
            }
            int k = diff.size() - 1;
            while (k >= 0) {
                ++open;
                b.append("(" + (this.entries[path.get(k)] == null ? " " : this.entries[path.get(k)]));
                if (k != 0 && path.size() - 1 != k && newLine) {
                    b.append("\n").append(this.createSpaces(open));
                }
                spaces = false;
                --k;
            }
            if (spaces) {
                b.append(this.createSpaces(open));
            } else {
                b.append(" ");
            }
            String term = this.entries[i];
            if (term.equals("(")) {
                term = "-LRB-";
            }
            if (term.equals(")")) {
                term = "-RRB-";
            }
            if (term.equals("{")) {
                term = "-LCB-";
            }
            if (term.equals("}")) {
                term = "-RCB-";
            }
            if ((ps = this.pos[i]).equals("(")) {
                ps = "-LRB-";
            }
            if (ps.equals("$(")) {
                ps = "-LRB-";
            }
            if (ps.equals(")")) {
                ps = "-RRB-";
            }
            if (ps.equals("{")) {
                ps = "-LCB-";
            }
            if (ps.equals("}")) {
                ps = "-RCB-";
            }
            b.append("(").append(ps).append(" ").append(term).append(')');
            current = path;
            ++i;
        }
        while (open > 0) {
            b.append(")");
            --open;
        }
        return b.toString();
    }

    private ArrayList<Integer> getDiffPath(ArrayList<Integer> path, ArrayList<Integer> current) {
        if (current == null) {
            return path;
        }
        ArrayList<Integer> common = new ArrayList<Integer>();
        int pindex = path.size() - 1;
        int cindex = current.size() - 1;
        while (cindex >= 0 && pindex >= 0) {
            if (path.get(pindex) != current.get(cindex)) break;
            --cindex;
            --pindex;
        }
        int k = 0;
        while (k <= pindex) {
            common.add(path.get(k));
            ++k;
        }
        return common;
    }

    private ArrayList<Integer> getDiffCommon(ArrayList<Integer> path, ArrayList<Integer> current) {
        if (current == null) {
            return path;
        }
        ArrayList<Integer> common = new ArrayList<Integer>();
        int pindex = path.size() - 1;
        int cindex = current.size() - 1;
        while (cindex >= 0 && pindex >= 0) {
            if (path.get(pindex) != current.get(cindex)) break;
            common.add(path.get(pindex));
            --cindex;
            --pindex;
        }
        Collections.reverse(common);
        return common;
    }

    private StringBuffer createSpaces(int i) {
        StringBuffer s = new StringBuffer();
        int k = 0;
        while (k < i) {
            s.append("  ");
            ++k;
        }
        return s;
    }

    private ArrayList<Integer> getPathToRoot(int i) {
        ArrayList<Integer> path = new ArrayList<Integer>();
        int h = i;
        while ((h = this.head[h]) >= this.terminalCount && !path.contains(h)) {
            path.add(h);
        }
        return path;
    }

    public String conll09() {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < this.terminalCount) {
            if (this.head[i] == -1 && this.entries[i] == null) break;
            s.append(i + 1).append('\t').append(this.entries[i]).append("\t_\t_\t").append(this.pos[i]).append("\t_\t_\t_\t_\t_\t_\t_\t_\n");
            ++i;
        }
        return s.toString();
    }

    public int[] getChilds(int head) {
        int count = 0;
        int i = 0;
        while (i < this.entries.length) {
            if (this.head[i] == head) {
                ++count;
            }
            ++i;
        }
        int[] clds = new int[count];
        count = 0;
        int i2 = 0;
        while (i2 < this.entries.length) {
            if (this.head[i2] == head) {
                clds[count++] = i2;
            }
            ++i2;
        }
        return clds;
    }
}

