/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.CharEncUtils;
import fig.basic.Pair;
import fig.basic.SysInfoUtils;
import fig.basic.Utils;
import fig.servlet.ArgumentException;
import fig.servlet.Authenticator;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.NameNotFoundException;
import fig.servlet.OperationRP;
import fig.servlet.Permissions;
import fig.servlet.ResponseObject;
import fig.servlet.ResponseParams;
import fig.servlet.RootItem;
import fig.servlet.UpdateQueue;
import fig.servlet.UpdateSpec;
import fig.servlet.WebState;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FigServlet
extends HttpServlet {
    private static final long serialVersionUID = 42L;
    private String prependFile;
    private RootItem rootItem;
    private Authenticator authenticator;
    private UpdaterThread updaterThread;

    public void init() {
        String propertiesFile = String.valueOf(this.getServletName()) + ".properties";
        ServletContext context = this.getServletContext();
        Properties properties = Utils.loadProperties(context.getRealPath(propertiesFile));
        CharEncUtils.setCharEncoding(properties.getProperty("encoding"));
        WebState.setServlet(this);
        WebState.logs(String.valueOf(this.getServletName()) + ".init()");
        this.prependFile = context.getRealPath(properties.getProperty("prependFile"));
        String varDir = FigServlet.parseVarDir(properties.getProperty("varDir"));
        this.rootItem = new RootItem(varDir.startsWith("/") ? varDir : context.getRealPath(varDir));
        this.authenticator = new Authenticator(this.rootItem);
        this.updaterThread = new UpdaterThread(this.rootItem);
        this.updaterThread.start();
    }

    private static String parseVarDir(String s) {
        return s.replace("HOSTNAME", SysInfoUtils.getShortHostName());
    }

    public void destroy() {
        WebState.logs(String.valueOf(this.getServletName()) + ".destroy()");
        this.updaterThread.terminate();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGetPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGetPost(request, response);
    }

    public void doGetPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block5: {
            WebState state = new WebState(request, response);
            Permissions perm = this.authenticator.getPermissions(state.request);
            this.printInfo(state, perm);
            String mode = state.params.get("mode", "display");
            try {
                if (mode.equals("auth")) {
                    this.givePermissions(state);
                    break block5;
                }
                if (mode.equals("op")) {
                    this.handleOperation(state, perm);
                    break block5;
                }
                if (mode.equals("display")) {
                    this.displayStuff(state, perm);
                    break block5;
                }
                throw new MyException("Invalid mode: " + mode);
            }
            catch (MyException e) {
                new ResponseParams(e).dump(state);
            }
        }
        this.updaterThread.hit();
        WebState.verboseLogs("doGetPost(): finished");
    }

    protected void printInfo(WebState state, Permissions perm) {
        boolean involveWorkers;
        String op = (String)state.params.get("op");
        boolean bl = involveWorkers = "setStatus".equals(op) || "getJob".equals(op);
        if (WebState.verbose) {
            WebState.logs("QUERY: " + state.request.getQueryString());
        }
    }

    private void givePermissions(WebState state) throws MyException, IOException {
        String auth = (String)state.params.get("auth");
        if (auth == null) {
            throw new ArgumentException("No authentication string specified");
        }
        boolean ok = this.authenticator.givePermissions(auth, state.response);
        new ResponseParams(ok, "Authenticated", "Invalid authentication").dump(state);
    }

    private void handleOperation(WebState state, Permissions perm, OperationRP req, Item item) throws MyException, IOException {
        ResponseObject resp = item.handleOperation(req, perm);
        resp.dump(state);
    }

    private void handleOperation(WebState state, Permissions perm, OperationRP req) throws MyException, IOException {
        try {
            Item item = this.rootItem.trailToItem(req.trail);
            this.handleOperation(state, perm, req, item);
        }
        catch (NameNotFoundException e) {
            this.updaterThread.updateQueue.enqueue(e.item, UpdateQueue.Priority.HIGH);
            throw e;
        }
    }

    private void handleOperation(WebState state, Permissions perm) throws MyException, IOException {
        OperationRP req = new OperationRP(state.params, this.updaterThread.getUpdateSpec());
        this.handleOperation(state, perm, req);
    }

    private void displayStuff(WebState state, Permissions perm) throws MyException, IOException {
        state.initOutput();
        if (new File(this.prependFile).exists()) {
            state.hw.writeFile(this.prependFile);
        }
        state.hw.begin("fig", "onload='onLoad()' onkeydown='onKeyPress(event)'", false);
        if (state.params.containsKey("op")) {
            this.handleOperation(state, perm);
        } else {
            OperationRP req = new OperationRP("getItemsTable", this.updaterThread.getUpdateSpec());
            req.put("name", "root");
            this.handleOperation(state, perm, req, this.rootItem);
        }
        state.hw.end();
        state.endOutput();
    }

    private static class UpdaterThread
    extends Thread {
        private RootItem rootItem;
        private UpdateQueue updateQueue;
        private int sleepInterval;
        private boolean done;
        private int initSleepInterval = 1000000000;
        private double sleepGrowthFactor = 1.2;

        public UpdaterThread(RootItem rootItem) {
            this.rootItem = rootItem;
            this.updateQueue = new UpdateQueue();
            this.done = false;
            this.sleepInterval = this.initSleepInterval;
        }

        public void update() {
            if (this.updateQueue.queueSize() == 0) {
                return;
            }
            try {
                Pair<Item, UpdateQueue.Priority> pair;
                WebState.logs("UpdaterThread.update(): " + this.updateQueue);
                while ((pair = this.updateQueue.dequeue()) != null) {
                    pair.getFirst().update(this.getUpdateSpec(), pair.getSecond());
                }
                this.updateQueue.clearEnqueued();
                WebState.logs("UpdaterThread.update(): finished");
            }
            catch (MyException e) {
                WebState.logs("UpdaterThread.update() failed: " + Utils.getStackTrace(e));
            }
        }

        @Override
        public void run() {
            WebState.logs("UpdaterThread.run(): begin");
            while (!this.done) {
                this.update();
                Utils.sleep(this.sleepInterval);
                this.sleepInterval = (int)((double)this.sleepInterval * this.sleepGrowthFactor);
            }
            WebState.logs("UpdaterThread.run(): done");
        }

        public void terminate() {
            this.done = true;
        }

        public void hit() {
            this.sleepInterval = this.initSleepInterval;
            this.interrupt();
        }

        public UpdateSpec getUpdateSpec() {
            return new UpdateSpec(this.updateQueue);
        }
    }
}

