/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.syntax;

import LinguaView.TreePanel;
import LinguaView.syntax.ConstTree;
import LinguaView.syntax.Tree;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.IdentityHashMap;
import java.util.List;

public class ConstTreePanel
extends TreePanel<ConstTree> {
    public boolean skewedLines = true;
    public boolean displayLA = true;
    int nodesCount;
    int laMargin = 0;
    IdentityHashMap<Tree<String>, Integer> indexTable;
    ConstTree[] nodesArray;
    int[] XMiddleArray;
    int[] YTopArray;
    int[] nodeLengthsArray;
    int[] nodeHeightsArray;

    @Override
    public void init() {
        this.loadFont();
        this.loadSentence();
        this.setPreferredSize(this.area);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void render(Graphics2D g2) {
        g2.setFont(this.font);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke());
        if (this.indexTable != null) {
            ConstTree t = (ConstTree)this.treebank.get(this.sentenceNumber);
            this.drawTree(g2, t);
        }
    }

    private void drawLine(int x1, int y1, int x2, int y2, Graphics2D g2) {
        if (!this.skewedLines) {
            int yM = y1 + (y2 - y1) / 2;
            g2.drawLine(x1, y1, x1, yM);
            g2.drawLine(x1, yM, x2, yM);
            g2.drawLine(x2, yM, x2, y2);
        } else {
            g2.drawLine(x1, y1, x2, y2);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.render(g2);
    }

    public void drawTree(Graphics2D g2, ConstTree n) {
        int i = this.indexTable.get(n);
        int thisY = this.YTopArray[i] + this.textTipMargin + this.fontHight;
        g2.drawString((String)n.getLabel(), this.XMiddleArray[i] - this.metrics.stringWidth((String)n.getLabel()) / 2, thisY);
        if (this.displayLA) {
            String[] stringArray = n.getLa();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String a = stringArray[n3];
                g2.setColor(Color.GRAY);
                g2.drawString(a, this.XMiddleArray[i] - this.metrics.stringWidth(a) / 2, thisY += this.fontHight + this.laMargin);
                g2.setColor(Color.BLACK);
                ++n3;
            }
        }
        for (ConstTree c : n.getConstChildren()) {
            int ci = this.indexTable.get(c);
            int cx = this.XMiddleArray[ci];
            int cy = this.YTopArray[ci];
            this.drawLine(this.XMiddleArray[i], thisY + this.textTipMargin, cx, cy, g2);
            this.drawTree(g2, c);
        }
    }

    @Override
    public void loadSentence() {
        ConstTree t = (ConstTree)this.treebank.get(this.sentenceNumber);
        if (t.getLabel() == null) {
            this.XMiddleArray = null;
            this.YTopArray = null;
            this.nodeLengthsArray = null;
            this.nodeHeightsArray = null;
            this.nodesCount = 0;
            this.area.width = 0;
            this.area.height = 0;
            return;
        }
        this.levelSize = 15.0;
        this.indexTable = new IdentityHashMap();
        this.nodesCount = t.constSubTreeList().size();
        this.nodesArray = t.constSubTreeList().toArray(new ConstTree[0]);
        this.XMiddleArray = new int[this.nodesCount];
        this.YTopArray = new int[this.nodesCount];
        this.nodeLengthsArray = new int[this.nodesCount];
        this.nodeHeightsArray = new int[this.nodesCount];
        int i = 0;
        ConstTree[] constTreeArray = this.nodesArray;
        int n = this.nodesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConstTree subt = constTreeArray[n2];
            this.indexTable.put(subt, i);
            ++i;
            ++n2;
        }
        this.calculateNodeLengthsAndHeights(this.nodesArray);
        int width = this.arrangeAllTerminals(this.nodesArray) - this.leftMargin;
        this.updateValues(t, this.topMargin);
        int height = this.alignVertical(t);
        this.area.width = width + this.leftMargin + this.rightMargin;
        this.area.height = height + this.bottomMargin;
    }

    public void calculateNodeLengthsAndHeights(ConstTree[] nodesArray) {
        int i = 0;
        while (i < nodesArray.length) {
            ConstTree n = nodesArray[i];
            int nodeLength = this.metrics.stringWidth((String)n.getLabel());
            if (this.displayLA) {
                String[] stringArray = n.getLa();
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String a = stringArray[n3];
                    if (nodeLength < this.metrics.stringWidth(a)) {
                        nodeLength = this.metrics.stringWidth(a);
                    }
                    ++n3;
                }
            }
            this.nodeLengthsArray[i] = nodeLength;
            int nodeHeight = this.fontHight + this.textTipMargin * 2;
            if (this.displayLA) {
                int k = 0;
                while (k < n.getLa().length) {
                    nodeHeight += this.fontHight + this.laMargin;
                    ++k;
                }
            }
            this.nodeHeightsArray[i] = nodeHeight;
            ++i;
        }
    }

    public int arrangeAllTerminals(ConstTree[] nodesArray) {
        int thisXLeft = this.leftMargin;
        ConstTree[] constTreeArray = nodesArray;
        int n = nodesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConstTree n3 = constTreeArray[n2];
            if (n3.isLeaf()) {
                int i = this.indexTable.get(n3);
                int columnLength = this.getColumnLengthColumn(n3);
                this.XMiddleArray[i] = thisXLeft + columnLength / 2;
                thisXLeft = thisXLeft + columnLength + this.wordSpace;
            }
            ++n2;
        }
        return thisXLeft - this.wordSpace;
    }

    private int getColumnLengthColumn(ConstTree n) {
        int nodeLength = this.nodeLengthsArray[this.indexTable.get(n)];
        while (n.parent != null && n.parent.getConstChildren().size() == 1) {
            n = n.parent;
            int i = this.indexTable.get(n);
            int length = this.nodeLengthsArray[i];
            if (length <= nodeLength) continue;
            nodeLength = length;
        }
        return nodeLength;
    }

    public int updateValues(ConstTree n, int thisY) {
        int i = this.indexTable.get(n);
        this.YTopArray[i] = thisY;
        if (n.isLeaf()) {
            return this.XMiddleArray[i] - this.nodeLengthsArray[i] / 2;
        }
        int k = 0;
        int nc = n.getChildren().size();
        int[] cXLeft = new int[nc];
        List<ConstTree> cs = n.getConstChildren();
        for (ConstTree c : cs) {
            cXLeft[k] = this.updateValues(c, thisY + this.nodeHeightsArray[i] + (int)this.levelSize);
            ++k;
        }
        int iRightMost = this.indexTable.get(cs.get(nc - 1));
        int xSpan = cXLeft[nc - 1] - cXLeft[0] + this.nodeLengthsArray[iRightMost];
        this.XMiddleArray[i] = cXLeft[0] + xSpan / 2;
        return this.XMiddleArray[i] - this.nodeLengthsArray[i] / 2;
    }

    public int alignVertical(ConstTree t) {
        int depth = t.getDepth();
        int lastYDown = this.topMargin;
        int d = 0;
        while (d < depth) {
            int i;
            List nl = t.getAtDepth(d);
            int[] LevelYTopArray = new int[nl.size()];
            int[] LevelYDownArray = new int[nl.size()];
            int k = 0;
            for (Tree n : nl) {
                int i2 = this.indexTable.get(n);
                LevelYTopArray[k] = this.YTopArray[i2];
                ++k;
            }
            int alignY = this.getMaximal(LevelYTopArray) > lastYDown ? this.getMaximal(LevelYTopArray) : lastYDown;
            for (Tree n : nl) {
                i = this.indexTable.get(n);
                this.YTopArray[i] = alignY;
            }
            k = 0;
            for (Tree n : nl) {
                i = this.indexTable.get(n);
                LevelYDownArray[k] = this.YTopArray[i] + this.nodeHeightsArray[i] + (int)this.levelSize;
                ++k;
            }
            lastYDown = this.getMaximal(LevelYDownArray);
            ++d;
        }
        return lastYDown;
    }

    private int getMaximal(int[] Array) {
        int min = Array[0];
        int[] nArray = Array;
        int n = Array.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            if (e > min) {
                min = e;
            }
            ++n2;
        }
        return min;
    }
}

