/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDebug;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PObjectOutputStream;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PCamera
extends PNode {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_LAYERS = "layers";
    public static final int PROPERTY_CODE_LAYERS = 2048;
    public static final String PROPERTY_VIEW_TRANSFORM = "viewTransform";
    public static final int PROPERTY_CODE_VIEW_TRANSFORM = 4096;
    public static final int VIEW_CONSTRAINT_NONE = 0;
    public static final int VIEW_CONSTRAINT_ALL = 1;
    public static final int VIEW_CONSTRAINT_CENTER = 2;
    private transient PComponent component;
    private transient List layers;
    private final PAffineTransform viewTransform = new PAffineTransform();
    private int viewConstraint = 0;
    private static final PBounds TEMP_REPAINT_RECT = new PBounds();

    public PCamera() {
        this.layers = new ArrayList();
    }

    public PComponent getComponent() {
        return this.component;
    }

    public void setComponent(PComponent pComponent) {
        this.component = pComponent;
        this.invalidatePaint();
    }

    public void repaintFrom(PBounds pBounds, PNode pNode) {
        if (this.getParent() != null) {
            if (pNode != this) {
                this.localToParent(pBounds);
            }
            if (this.component != null) {
                this.component.repaint(pBounds);
            }
            this.getParent().repaintFrom(pBounds, this);
        }
    }

    public void repaintFromLayer(PBounds pBounds, PLayer pLayer) {
        TEMP_REPAINT_RECT.setRect(pBounds);
        this.viewToLocal(TEMP_REPAINT_RECT);
        if (this.getBoundsReference().intersects(TEMP_REPAINT_RECT)) {
            Rectangle2D.intersect(TEMP_REPAINT_RECT, this.getBoundsReference(), TEMP_REPAINT_RECT);
            this.repaintFrom(TEMP_REPAINT_RECT, pLayer);
        }
    }

    public void repaintFromLayer(PBounds pBounds, PNode pNode) {
        throw new IllegalArgumentException("repaintedLayer not an instance of PLayer");
    }

    public List getLayersReference() {
        return this.layers;
    }

    public int getLayerCount() {
        return this.layers.size();
    }

    public PLayer getLayer(int n) {
        return (PLayer)this.layers.get(n);
    }

    public int indexOfLayer(PLayer pLayer) {
        return this.layers.indexOf(pLayer);
    }

    public void addLayer(PLayer pLayer) {
        this.addLayer(this.layers.size(), pLayer);
    }

    public void addLayer(int n, PLayer pLayer) {
        this.layers.add(n, pLayer);
        pLayer.addCamera(this);
        this.invalidatePaint();
        this.firePropertyChange(2048, PROPERTY_LAYERS, null, this.layers);
    }

    public PLayer removeLayer(PLayer pLayer) {
        pLayer.removeCamera(this);
        if (this.layers.remove(pLayer)) {
            this.invalidatePaint();
            this.firePropertyChange(2048, PROPERTY_LAYERS, null, this.layers);
        }
        return pLayer;
    }

    public PLayer removeLayer(int n) {
        PLayer pLayer = (PLayer)this.layers.remove(n);
        pLayer.removeCamera(this);
        this.invalidatePaint();
        this.firePropertyChange(2048, PROPERTY_LAYERS, null, this.layers);
        return pLayer;
    }

    public PBounds getUnionOfLayerFullBounds() {
        PBounds pBounds = new PBounds();
        int n = this.layers.size();
        for (int i = 0; i < n; ++i) {
            PLayer pLayer = (PLayer)this.layers.get(i);
            pBounds.add(pLayer.getFullBoundsReference());
        }
        return pBounds;
    }

    protected void paint(PPaintContext pPaintContext) {
        super.paint(pPaintContext);
        pPaintContext.pushClip(this.getBoundsReference());
        pPaintContext.pushTransform(this.viewTransform);
        this.paintCameraView(pPaintContext);
        this.paintDebugInfo(pPaintContext);
        pPaintContext.popTransform(this.viewTransform);
        pPaintContext.popClip(this.getBoundsReference());
    }

    protected void paintCameraView(PPaintContext pPaintContext) {
        int n = this.layers.size();
        for (int i = 0; i < n; ++i) {
            PLayer pLayer = (PLayer)this.layers.get(i);
            pLayer.fullPaint(pPaintContext);
        }
    }

    protected void paintDebugInfo(PPaintContext pPaintContext) {
        if (PDebug.debugBounds || PDebug.debugFullBounds) {
            Graphics2D graphics2D = pPaintContext.getGraphics();
            pPaintContext.setRenderQuality(0);
            graphics2D.setStroke(new BasicStroke(0.0f));
            ArrayList arrayList = new ArrayList();
            PBounds pBounds = new PBounds();
            Color color = Color.red;
            Color color2 = new Color(1.0f, 0.0f, 0.0f, 0.2f);
            int n = this.layers.size();
            for (int i = 0; i < n; ++i) {
                ((PLayer)this.layers.get(i)).getAllNodes(null, arrayList);
            }
            Iterator iterator = this.getAllNodes(null, arrayList).iterator();
            while (iterator.hasNext()) {
                PNode pNode = (PNode)iterator.next();
                if (PDebug.debugBounds) {
                    graphics2D.setPaint(color);
                    pBounds.setRect(pNode.getBoundsReference());
                    if (!pBounds.isEmpty()) {
                        pNode.localToGlobal(pBounds);
                        this.globalToLocal(pBounds);
                        if (pNode == this || pNode.isDescendentOf(this)) {
                            this.localToView(pBounds);
                        }
                        graphics2D.draw(pBounds);
                    }
                }
                if (!PDebug.debugFullBounds) continue;
                graphics2D.setPaint(color2);
                pBounds.setRect(pNode.getFullBoundsReference());
                if (pBounds.isEmpty()) continue;
                if (pNode.getParent() != null) {
                    pNode.getParent().localToGlobal(pBounds);
                }
                this.globalToLocal(pBounds);
                if (pNode == this || pNode.isDescendentOf(this)) {
                    this.localToView(pBounds);
                }
                graphics2D.fill(pBounds);
            }
        }
    }

    public void fullPaint(PPaintContext pPaintContext) {
        pPaintContext.pushCamera(this);
        super.fullPaint(pPaintContext);
        pPaintContext.popCamera();
    }

    public PPickPath pick(double d, double d2, double d3) {
        PBounds pBounds = new PBounds(new Point2D.Double(d, d2), -d3, -d3);
        PPickPath pPickPath = new PPickPath(this, pBounds);
        this.fullPick(pPickPath);
        if (pPickPath.getNodeStackReference().size() == 0) {
            pPickPath.pushNode(this);
            pPickPath.pushTransform(this.getTransformReference(false));
        }
        return pPickPath;
    }

    protected boolean pickAfterChildren(PPickPath pPickPath) {
        if (this.intersects(pPickPath.getPickBounds())) {
            pPickPath.pushTransform(this.viewTransform);
            if (this.pickCameraView(pPickPath)) {
                return true;
            }
            pPickPath.popTransform(this.viewTransform);
            return true;
        }
        return false;
    }

    protected boolean pickCameraView(PPickPath pPickPath) {
        int n = this.layers.size();
        for (int i = n - 1; i >= 0; --i) {
            PLayer pLayer = (PLayer)this.layers.get(i);
            if (!pLayer.fullPick(pPickPath)) continue;
            return true;
        }
        return false;
    }

    public PBounds getViewBounds() {
        return (PBounds)this.localToView(this.getBounds());
    }

    public void setViewBounds(Rectangle2D rectangle2D) {
        this.animateViewToCenterBounds(rectangle2D, true, 0L);
    }

    public double getViewScale() {
        return this.viewTransform.getScale();
    }

    public void scaleView(double d) {
        this.scaleViewAboutPoint(d, 0.0, 0.0);
    }

    public void scaleViewAboutPoint(double d, double d2, double d3) {
        this.viewTransform.scaleAboutPoint(d, d2, d3);
        this.applyViewConstraints();
        this.invalidatePaint();
        this.firePropertyChange(4096, PROPERTY_VIEW_TRANSFORM, null, this.viewTransform);
    }

    public void setViewScale(double d) {
        this.scaleView(d / this.getViewScale());
    }

    public void translateView(double d, double d2) {
        this.viewTransform.translate(d, d2);
        this.applyViewConstraints();
        this.invalidatePaint();
        this.firePropertyChange(4096, PROPERTY_VIEW_TRANSFORM, null, this.viewTransform);
    }

    public void setViewOffset(double d, double d2) {
        this.viewTransform.setOffset(d, d2);
        this.applyViewConstraints();
        this.invalidatePaint();
        this.firePropertyChange(4096, PROPERTY_VIEW_TRANSFORM, null, this.viewTransform);
    }

    public PAffineTransform getViewTransform() {
        return (PAffineTransform)this.viewTransform.clone();
    }

    public PAffineTransform getViewTransformReference() {
        return this.viewTransform;
    }

    public void setViewTransform(AffineTransform affineTransform) {
        this.viewTransform.setTransform(affineTransform);
        this.applyViewConstraints();
        this.invalidatePaint();
        this.firePropertyChange(4096, PROPERTY_VIEW_TRANSFORM, null, this.viewTransform);
    }

    public PTransformActivity animateViewToCenterBounds(Rectangle2D rectangle2D, boolean bl, long l) {
        double d;
        PBounds pBounds = this.getViewBounds();
        PDimension pDimension = pBounds.deltaRequiredToCenter(rectangle2D);
        PAffineTransform pAffineTransform = this.getViewTransform();
        pAffineTransform.translate(pDimension.width, pDimension.height);
        if (bl && (d = Math.min(pBounds.getWidth() / rectangle2D.getWidth(), pBounds.getHeight() / rectangle2D.getHeight())) != Double.POSITIVE_INFINITY && d != 0.0) {
            pAffineTransform.scaleAboutPoint(d, rectangle2D.getCenterX(), rectangle2D.getCenterY());
        }
        return this.animateViewToTransform(pAffineTransform, l);
    }

    public PTransformActivity animateViewToPanToBounds(Rectangle2D rectangle2D, long l) {
        PBounds pBounds = this.getViewBounds();
        PDimension pDimension = pBounds.deltaRequiredToContain(rectangle2D);
        if (pDimension.width != 0.0 || pDimension.height != 0.0) {
            if (l == 0L) {
                this.translateView(-pDimension.width, -pDimension.height);
            } else {
                PAffineTransform pAffineTransform = this.getViewTransform();
                pAffineTransform.translate(-pDimension.width, -pDimension.height);
                return this.animateViewToTransform(pAffineTransform, l);
            }
        }
        return null;
    }

    public PTransformActivity animateViewToIncludeBounds(Rectangle2D rectangle2D, long l) {
        return this.animateViewToPanToBounds(rectangle2D, l);
    }

    public PTransformActivity animateViewToTransform(AffineTransform affineTransform, long l) {
        if (l == 0L) {
            this.setViewTransform(affineTransform);
            return null;
        }
        PTransformActivity.Target target = new PTransformActivity.Target(){

            public void setTransform(AffineTransform affineTransform) {
                PCamera.this.setViewTransform(affineTransform);
            }

            public void getSourceMatrix(double[] dArray) {
                PCamera.this.viewTransform.getMatrix(dArray);
            }
        };
        PTransformActivity pTransformActivity = new PTransformActivity(l, PUtil.DEFAULT_ACTIVITY_STEP_RATE, target, affineTransform);
        PRoot pRoot = this.getRoot();
        if (pRoot != null) {
            pRoot.getActivityScheduler().addActivity(pTransformActivity);
        }
        return pTransformActivity;
    }

    public int getViewConstraint() {
        return this.viewConstraint;
    }

    public void setViewConstraint(int n) {
        if (n != 0 && n != 2 && n != 1) {
            throw new IllegalArgumentException("view constraint must be one of VIEW_CONSTRAINT_NONE, VIEW_CONSTRAINT_CENTER, or VIEW_CONSTRAINT_ALL");
        }
        this.viewConstraint = n;
        this.applyViewConstraints();
    }

    protected void applyViewConstraints() {
        if (0 == this.viewConstraint) {
            return;
        }
        PBounds pBounds = this.getViewBounds();
        PBounds pBounds2 = (PBounds)this.globalToLocal(this.getUnionOfLayerFullBounds());
        if (2 == this.viewConstraint) {
            pBounds2.setRect(pBounds2.getCenterX(), pBounds2.getCenterY(), 0.0, 0.0);
        }
        PDimension pDimension = pBounds.deltaRequiredToContain(pBounds2);
        this.viewTransform.translate(-pDimension.width, -pDimension.height);
    }

    public Point2D viewToLocal(Point2D point2D) {
        return this.viewTransform.transform(point2D, point2D);
    }

    public Dimension2D viewToLocal(Dimension2D dimension2D) {
        return this.viewTransform.transform(dimension2D, dimension2D);
    }

    public Rectangle2D viewToLocal(Rectangle2D rectangle2D) {
        return this.viewTransform.transform(rectangle2D, rectangle2D);
    }

    public Point2D localToView(Point2D point2D) {
        return this.viewTransform.inverseTransform(point2D, point2D);
    }

    public Dimension2D localToView(Dimension2D dimension2D) {
        return this.viewTransform.inverseTransform(dimension2D, dimension2D);
    }

    public Rectangle2D localToView(Rectangle2D rectangle2D) {
        return this.viewTransform.inverseTransform(rectangle2D, rectangle2D);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!(objectOutputStream instanceof PObjectOutputStream)) {
            throw new RuntimeException("cannot serialize PCamera to a non PObjectOutputStream");
        }
        objectOutputStream.defaultWriteObject();
        int n = this.getLayerCount();
        for (int i = 0; i < n; ++i) {
            ((PObjectOutputStream)objectOutputStream).writeConditionalObject(this.layers.get(i));
        }
        objectOutputStream.writeObject(Boolean.FALSE);
        ((PObjectOutputStream)objectOutputStream).writeConditionalObject(this.component);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.layers = new ArrayList();
        while (true) {
            Object object;
            if ((object = objectInputStream.readObject()) == null) {
                continue;
            }
            if (object.equals(Boolean.FALSE)) break;
            this.layers.add(object);
        }
        this.component = (PComponent)objectInputStream.readObject();
    }
}

