/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.Collections;
import com.aliasi.util.Strings;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays {
    static final char BACKSLASH_CHAR = '\\';
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    @Deprecated
    public static final char[] EMPTY_CHAR_ARRAY = Strings.EMPTY_CHAR_ARRAY;
    @Deprecated
    public static final String[] EMPTY_STRING_ARRAY = Strings.EMPTY_STRING_ARRAY;

    private Arrays() {
    }

    public static <E> E[] reallocate(E[] xs, int newSize) {
        Object[] ys = (Object[])Array.newInstance(xs.getClass().getComponentType(), newSize);
        int end = Math.min(xs.length, newSize);
        for (int i = 0; i < end; ++i) {
            ys[i] = xs[i];
        }
        return ys;
    }

    public static int[] reallocate(int[] xs, int newSize) {
        int[] ys = new int[newSize];
        int end = Math.min(xs.length, newSize);
        for (int i = 0; i < end; ++i) {
            ys[i] = xs[i];
        }
        return ys;
    }

    public static int[] reallocate(int[] xs) {
        int len = xs.length * 3 / 2;
        return Arrays.reallocate(xs, len == xs.length ? xs.length + 1 : len);
    }

    public static char[] add(char c, char[] cs) {
        int i;
        if (java.util.Arrays.binarySearch(cs, c) >= 0) {
            return cs;
        }
        char[] result = new char[cs.length + 1];
        for (i = 0; i < cs.length && c > cs[i]; ++i) {
            result[i] = cs[i];
        }
        result[i] = c;
        ++i;
        while (i < result.length) {
            result[i] = cs[i - 1];
            ++i;
        }
        return result;
    }

    public static char[] copy(char[] cs) {
        if (cs == null) {
            return null;
        }
        char[] cs2 = new char[cs.length];
        for (int i = 0; i < cs.length; ++i) {
            cs2[i] = cs[i];
        }
        return cs2;
    }

    public static char[] toArray(CharSequence cSeq) {
        char[] cs = new char[cSeq.length()];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = cSeq.charAt(i);
        }
        return cs;
    }

    @Deprecated
    public static String[] csvToArray(String csvs) {
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        StringBuilder sb = new StringBuilder();
        while (pos < csvs.length()) {
            char c;
            if ((c = csvs.charAt(pos++)) == ',') {
                list.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            if (c == '\\') {
                if (pos >= csvs.length()) {
                    String msg = "Illegal end on backslash CSVs=|" + csvs + "|";
                    throw new IllegalArgumentException(msg);
                }
                char nextChar = csvs.charAt(pos++);
                if (Arrays.csvEscape(c)) {
                    sb.append(nextChar);
                    continue;
                }
                String msg = "Illegal escape following backslash. Position=" + pos + " CVSs=" + csvs;
                throw new IllegalArgumentException(msg);
            }
            sb.append(c);
        }
        list.add(sb.toString());
        return Collections.toStringArray(list);
    }

    @Deprecated
    public static String[][] csvToArray2D(String csvs) {
        int start;
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (int end = start = 0; end < csvs.length(); ++end) {
            char c = csvs.charAt(end);
            if (c == '\n') {
                result.add(Arrays.csvToArray(csvs.substring(start, end)));
                start = end + 1;
                continue;
            }
            if (c != '\\') continue;
            if (++end >= csvs.length()) {
                String msg = "Premature end on backslash. csvs=" + csvs;
                throw new IllegalArgumentException(msg);
            }
            char escapedC = csvs.charAt(end);
            if (Arrays.csvEscape(escapedC)) continue;
            String msg = "Illegal escape. position=" + (end - 1) + " char= " + escapedC;
            throw new IllegalArgumentException(msg);
        }
        result.add(Arrays.csvToArray(csvs.substring(start)));
        return (String[][])result.toArray((T[])Strings.EMPTY_STRING_2D_ARRAY);
    }

    @Deprecated
    public static String arrayToCSV(String[][] elts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < elts.length; ++i) {
            if (i > 0) {
                sb.append('\n');
            }
            Arrays.arrayToCSV(elts[i], sb);
        }
        return sb.toString();
    }

    @Deprecated
    public static String arrayToCSV(Object[] xs) {
        StringBuilder sb = new StringBuilder();
        Arrays.arrayToCSV(xs, sb);
        return sb.toString();
    }

    static void arrayToCSV(Object[] xs, StringBuilder sb) {
        for (int i = 0; i < xs.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            Arrays.csvEncode(xs[i].toString(), sb);
        }
    }

    static void csvEncode(String in, StringBuilder sb) {
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (Arrays.csvEscape(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
    }

    static boolean csvEscape(char c) {
        return c == '\\' || c == ',' || c == '\n';
    }

    public static boolean member(Object x, Object[] xs) {
        if (xs == null) {
            return false;
        }
        int i = xs.length;
        while (--i >= 0) {
            if (xs[i] == null || !xs[i].equals(x)) continue;
            return true;
        }
        return false;
    }

    public static boolean member(char c, char[] cs) {
        if (cs == null) {
            return false;
        }
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] != c) continue;
            return true;
        }
        return false;
    }

    public static String arrayToString(Object[] xs) {
        StringBuilder sb = new StringBuilder();
        Arrays.arrayToStringBuilder(sb, xs);
        return sb.toString();
    }

    public static void arrayToStringBuilder(StringBuilder sb, Object[] xs) {
        sb.append('[');
        for (int i = 0; i < xs.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(xs[i]);
        }
        sb.append(']');
    }

    public static char[] concatenate(char[] cs, char c) {
        char[] result = new char[cs.length + 1];
        for (int i = 0; i < cs.length; ++i) {
            result[i] = cs[i];
        }
        result[result.length - 1] = c;
        return result;
    }

    public static String[] concatenate(String[] xs, String[] ys) {
        String[] result = new String[xs.length + ys.length];
        System.arraycopy(xs, 0, result, 0, xs.length);
        System.arraycopy(ys, 0, result, xs.length, ys.length);
        return result;
    }

    @Deprecated
    public static int sum(int[] xs) {
        int sum = 0;
        for (int i = 0; i < xs.length; ++i) {
            sum += xs[i];
        }
        return sum;
    }

    public static boolean equals(Object[] xs, Object[] ys) {
        if (xs.length != ys.length) {
            return false;
        }
        for (int i = 0; i < xs.length; ++i) {
            if (xs[i].equals(ys[i])) continue;
            return false;
        }
        return true;
    }

    public static <E> void permute(E[] xs) {
        Arrays.permute(xs, new Random());
    }

    public static <E> void permute(E[] xs, Random random) {
        int i = xs.length;
        while (--i > 0) {
            int pos = random.nextInt(i);
            E temp = xs[pos];
            xs[pos] = xs[i];
            xs[i] = temp;
        }
    }

    public static void permute(int[] xs) {
        Arrays.permute(xs, new Random());
    }

    public static void permute(int[] xs, Random random) {
        int i = xs.length;
        while (--i > 0) {
            int pos = random.nextInt(i);
            int temp = xs[pos];
            xs[pos] = xs[i];
            xs[i] = temp;
        }
    }
}

