/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.medline;

import com.aliasi.corpus.XMLParser;
import com.aliasi.medline.MedlineCitation;
import com.aliasi.medline.MedlineHandler;
import com.aliasi.xml.DelegateHandler;
import com.aliasi.xml.DelegatingHandler;
import com.aliasi.xml.TextAccumulatorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class MedlineParser
extends XMLParser<MedlineHandler> {
    private final boolean mIncludeRawXML;

    public MedlineParser(boolean includeRawXML) {
        this(null, includeRawXML);
    }

    public MedlineParser(MedlineHandler handler, boolean includeRawXML) {
        super(handler);
        this.mIncludeRawXML = includeRawXML;
    }

    @Deprecated
    public void parse(InputSource inSource, MedlineHandler handler) throws IOException, SAXException {
        this.setHandler(handler);
        this.parse(inSource);
    }

    @Override
    protected DefaultHandler getXMLHandler() {
        return new VisitingHandler((MedlineHandler)this.getHandler(), this.mIncludeRawXML);
    }

    private static class VisitingHandler
    extends DelegatingHandler {
        private final MedlineHandler mVisitor;
        private StringBuilder mXMLBuffer = new StringBuilder();
        private final boolean mSaveXML;
        private final DeletionHandler mDeletionHandler;

        public VisitingHandler(MedlineHandler visitor) {
            this(visitor, true);
        }

        public VisitingHandler(MedlineHandler visitor, boolean saveXML) {
            this.mVisitor = visitor;
            this.mSaveXML = saveXML;
            this.setDelegate("MedlineCitation", new MedlineCitation.Handler(this));
            this.mDeletionHandler = new DeletionHandler(this);
            this.setDelegate("DeleteCitation", this.mDeletionHandler);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.mSaveXML) {
                if (qName.equals("MedlineCitation")) {
                    this.mXMLBuffer = new StringBuilder();
                    this.mXMLBuffer.append("<MedlineCitation");
                    this.appendAttributes(atts);
                    this.mXMLBuffer.append('>');
                } else {
                    this.mXMLBuffer.append('<');
                    this.mXMLBuffer.append(qName);
                    this.appendAttributes(atts);
                    this.mXMLBuffer.append('>');
                }
            }
            super.startElement(namespaceURI, localName, qName, atts);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.mSaveXML) {
                this.mXMLBuffer.append("</");
                this.mXMLBuffer.append(qName);
                this.mXMLBuffer.append('>');
            }
            super.endElement(namespaceURI, localName, qName);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.mSaveXML) {
                this.appendCharacters(ch, start, length);
            }
            super.characters(ch, start, length);
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (!"-//NLM//DTD Medline Citation, 1st January, 2010//EN".equals(publicId)) {
                System.out.println("publicId=|" + publicId + "|");
                return super.resolveEntity(publicId, systemId);
            }
            InputStream in = this.getClass().getResourceAsStream("/com/aliasi/medline/nlmmedlinecitationset_100101.dtd");
            return new InputSource(in);
        }

        public void finishDelegate(String qName, DefaultHandler handler) {
            if (qName.equals("MedlineCitation")) {
                MedlineCitation.Handler citationHandler = (MedlineCitation.Handler)handler;
                MedlineCitation citation = citationHandler.getCitation();
                if (this.mSaveXML) {
                    citation.setXMLString(this.mXMLBuffer.toString());
                }
                this.mVisitor.handle(citation);
            }
            if (qName.equals("DeleteCitation")) {
                for (String pmid : this.mDeletionHandler.deletionSet()) {
                    this.mVisitor.delete(pmid);
                }
            }
        }

        private void appendAttributes(Attributes atts) {
            for (int i = 0; i < atts.getLength(); ++i) {
                this.mXMLBuffer.append(' ');
                this.mXMLBuffer.append(atts.getQName(i));
                this.mXMLBuffer.append("=\"");
                char[] cs = atts.getValue(i).toCharArray();
                this.appendCharacters(cs, 0, cs.length);
                this.mXMLBuffer.append('\"');
            }
        }

        private void appendCharacters(char[] cs, int start, int length) {
            block6: for (int i = 0; i < length; ++i) {
                char c = cs[start + i];
                switch (c) {
                    case '<': {
                        this.mXMLBuffer.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        this.mXMLBuffer.append("&gt;");
                        continue block6;
                    }
                    case '&': {
                        this.mXMLBuffer.append("&amp;");
                        continue block6;
                    }
                    case '\"': {
                        this.mXMLBuffer.append("&quot;");
                        continue block6;
                    }
                    default: {
                        this.mXMLBuffer.append(c);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeletionHandler
    extends DelegateHandler {
        TextAccumulatorHandler mPMIDHandler = new TextAccumulatorHandler();
        Set<String> mDeletions = new HashSet<String>();

        public DeletionHandler(DelegatingHandler delegator) {
            super(delegator);
            this.setDelegate("PMID", this.mPMIDHandler);
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.mPMIDHandler.reset();
            this.mDeletions = new HashSet<String>();
        }

        @Override
        public void finishDelegate(String qName, DefaultHandler handler) {
            if (qName.equals("PMID")) {
                this.mDeletions.add(this.mPMIDHandler.getText());
            }
        }

        public Set<String> deletionSet() {
            return this.mDeletions;
        }
    }
}

