ALPHABET = [A-Za-z\$\%\&\'\(\)\*\+,\-\./0-9\:_\`]

$C$ = [BCDFGHJKLMNPQRSTVWXZ]
$L$ = [A-Z]
$l$ = [a-z]
$prefix$ = $l$ $l$ $l$+
$Prefix$ = $L$ $l$ $l$+
$PREFIX$ = $L$ $L$ $L$+

$T1$ = .+ \- (\
based	<1> |\
old	<2> |\
share	<3> |\
year	<4> |\
owned	<5> |\
related	<6> |\
day 	<7> |\
up 	<8> |\
point 	<9> |\
month 	<10> |\
member 	<11> |\
market 	<12> |\
like 	<13> |\
hour 	<14> |\
products 	<15> |\
out 	<16> |\
oriented 	<17> |\
industry 	<18> |\
backed 	<19> |\
foot 	<20> |\
time 	<21> |\
tax 	<22> |\
rate 	<23> |\
store 	<24> |\
processing <25> |\
plus 	<26> |\
making 	<27> |\
week 	<28> |\
story 	<29> |\
stock 	<30> |\
price 	<31> |\
page 	<32> |\
management <33> |\
income 	<34> |\
care 	<35> |\
acre 	<36> |\
trading 	<37> |\
service 	<38> |\
off 	<39> |\
mile 	<40> |\
level 	<41> |\
free 	<42> |\
controlled <43> |\
control 	<44> |\
term 	<45> |\
services 	<46> |\
made 	<47> |\
law 	<48> |\
inch 	<49> |\
fund 	<50> |\
cost 	<51> |\
style 	<52> |\
sponsored 	<53> |\
run 	<54> |\
quality 	<55> |\
pound 	<56> |\
nation	<57> |\
interest 	<58> |\
down 	<59>)

$T2$ = \
"Data/JJ.cap" <60> |\
"Data/JJR.cap" <61> |\
"Data/JJS.cap" <62> |\
"Data/NN.cap" <63> |\
"Data/NNS.cap" <64> |\
"Data/RB.cap" <65> |\
"Data/VV.cap" <66> |\
"Data/VVD.cap" <67> |\
"Data/VVG.cap" <68> |\
"Data/VVN.cap" <69> |\
"Data/VVZ.cap" <70> |\
"Data/JJ.uc" <71> |\
"Data/JJR.uc" <72> |\
"Data/JJS.uc" <73> |\
"Data/NN.uc" <74> |\
"Data/NNS.uc" <75> |\
"Data/RB.uc" <76> |\
"Data/VV.uc" <77> |\
"Data/VVD.uc" <78> |\
"Data/VVG.uc" <79> |\
"Data/VVN.uc" <80> |\
"Data/VVZ.uc" <81>

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% lower-case words %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

$T3$ = \
([,.;:!?#/*\%\$\-]|,,|``|\.\.\.) <82> |\
$l$	<83> |\
$prefix$ (\
  eed	<84> |\
  ed	<85> |\
  ing	<86> |\
  ly	<87> |\
  est	<88> |\
  ous	<89> |\
  able	<90> |\
  ible	<91> |\
  ful	<92> |\
  ic	<93> |\
  al	<94> |\
  ive	<95> |\
  ian	<96> |\
  ory	<97> |\
  ier	<98> |\
  fer	<99> |\
  er	<100> |\
  ery	<101> |\
  ist	<102> |\
  ee	<103> |\
  ness	<104> |\
  ment	<105> |\
  ion	<106> |\
  (ty|ogy|cy)	<107> |\
  ence	<108> |\
  ance	<109> |\
  age	<110> |\
  ant	<111> |\
  ism	<112> |\
  or	<113> |\
  ([eo]rie|ic|al|ian|ive|ist|ing)s	<114> |\
  (ment|ist|ion|[ae]nce|age|ant|or|sm)s	<115> |\
  ifies		<116> |\
  (ee|er|ie)s	<117> |\
  [aeiou]tes	<118> |\
  izes		<119> |\
  on?es		<120> |\
  es		<121> |\
  [a-z\/]*ss	<122> |\
  [a-z\/]*us	<123> |\
  [a-z\/]*is	<124> |\
  [a-z\/]* s	<125> |\
  [aeiou]te	<126> |\
  ify		<127> |\
  y		<128>) |\
pre\- $l$ .*	<129> |\
(mid|non|anti|ex|post|pre|pro|then|trans)\- $L$ .*		<130> |\
(mid|non|anti|ex|post|pre|pro|then|trans|top)\- [a-z0-9] .*s	<131> |\
(mid|non|anti|ex|post|pre|pro|then|trans|top)\- [a-z0-9] .*	<132> |\
((single|double|triple)\-?[A-Da](\-(minus|plus|[1-3])))?	<133> |\
[ABC]a+(a|\-?[1-3])                               		<134> |\
[a-z\/]+men	<135> |\
[a-z\/]+i	<136> |\
[a-z\/]+ize	<137> |\
[a-z\/]+s	<138> |\
[a-z\/]+a	<139> |\
[a-z\/]+ught	<140> |\
[a-z\/]+ed	<141> |\
[a-z\/]+ing	<142> |\
[a-z\/]+ken	<143> |\
[a-z\/]+ung	<144> |\
[a-z\/]+ular	<145> |\
[a-z\/]+ent	<146> |\
[a-z\/]+some	<147> |\
[a-z\/]+paid	<148> |\
[a-z\/]+wide	<149> |\
[a-z\/]+en	<150> |\
[a-z\/]+ept	<151> |\
[a-z\/]+fold	<152> |\
[a-z\/]+ward	<153> |\
[a-z\/]+	<154> |\
.+ \- $prefix$ ed	<155> |\
.+ \- $prefix$ ing	<156> |\
.+ \- $prefix$ ous	<157> |\
$l$ .+ (\- [a-zA-Z]+)+ers	<158> |\
$l$ .+ (\- [a-zA-Z]+)+er	<159> |\
$l$ .+ (\- [a-zA-Z]+)+ss	<160> |\
$l$ .+ (\- [a-zA-Z]+)+s		<161> |\
$l$ .+ (\- [a-zA-Z][a-zA-Z]+)+	<162>

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% capitalized words %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

$T4$ = \
$L$	<163> |\
$Prefix$ (\
  ian	<164> |\
  ed	<165> |\
  ing	<166> |\
  ly	<167> |\
  (ous|[ai]ble|ful|ic|al|ory|ive)	<168> |\
  (ty|ogy|cy)	<169> |\
  (er|ery|ist|ee|ness|ment|ion|ence|ance|age|ant|ism|or)	<170> |\
  ([ai]ble|ful|ic|al|orie|ive|tie|ogie|cie|erie|ist|nesse|ment|ion|ence|ance|age|ant|ism|or|an|ing)s	<171> |\
  (ee|er|ie)s	<172> |\
  ss	<173> |\
  us	<174> |\
  is	<175> |\
  s	<176>) |\
(Ma?c|L[ae]|D[aei]|O\') $L$ $l$+ (\-$L$ $l$+)*	<177> |\
$L$ $l$+ (\-$L$ $l$+)*ish	<178> |\
$L$ $l$+ (\-$L$ $l$+)*ing	<179> |\
$L$ $l$+ (\-$L$ $l$+)*men	<180> |\
$L$ $l$+ (\-$L$ $l$+)*ican	<181> |\
$L$ $l$+ (\-$L$ $l$+)*st	<182> |\
$L$ $l$+ (\-$L$ $l$+)*s		<183> |\
$L$ $l$+ (\-$L$ $l$+)*nese	<184> |\
$L$ $l$+ (\-$L$ $l$+)*ean	<185> |\
$L$ $l$+ (\-$L$ $l$+)*ase	<186> |\
$L$ $l$+ (\-$L$ $l$+)* 		<187> |\
([A-Za-z]\')? $L$ $prefix$	<188>

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% upper-case words %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

$T5$ = \
$C$+ $C$ <189> |\
$PREFIX$ (\
  ED	<190> |\
  ING	<191> |\
  (OUS|[AI]BLE|FUL|IC|AL|ORY|IVE)	<192> |\
  (TY|OGY|CY|ER|ERY|IST|NESS|MENT|ION|ENCE|ANCE|AGE|ANT|ISM|OR)	<193> |\
  ([AI]BLE|FUL|IC|AL|ORIE|IVE|TIE|OGIE|CIE|ER|ERIE|IST|EE|NESSE|MENT|ION|ENCE|ANCE|AGE|ANT|ISM|OR|AN|ING)S	<194> |\
  S	<195>) |\
$L$ [A-Z\']+		<196> |\
$L$+\$			<197> |\
($L$+ \&)+ $L$		<198> |\
$L$ $l$+($L$ $l$+)*	<199> |\
$L$.* $l$s		<200> |\
$L$.*\- $l$ $l$+	<201> |\
$L$.*\- $L$ $l$+	<202> |\
$L$.*\- $L$ $L$+	<203> |\
$L$ \. ([A-Za-z] \.)* [A-Za-z]?	<204> |\
$L$ [A-Za-z]+ \.	<205>

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% numbers %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

$T6$ = \
\'? [0-9.,:\%/\-]* [0-9] \.?	<206> |\
[0-9]* (1st|2nd|3rd|[4-9]th)	<207> |\
\'? [0-9][0-9]+ s		<208> |\
[0-9][0-9,.\%\/]* \-? $l$[a-z\$?0-9,\-]+	<209>

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% other stuff %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

$T7$ = \
$L$ [0-9A-Za-z.\-]+ s		<210> |\
.+. $L$ \. $L$ \.?		<211> |\
$L$ [A-Za-z]+\/ $L$ [A-Za-z]+	<212> |\
([A-Z0-9]+ [\&\/\-])* [A-Z0-9]+	<213> |\
[A-Z0-9a-z]+ \-? [A-Z0-9a-z]+	<214> |\
.*	<215>

$T1$ | $T2$ | $T3$ | $T4$ | $T5$ | $T6$ | $T7$
