/*
 * Decompiled with CFR 0.152.
 */
package tsg.parsingExp;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import settings.Parameters;
import tsg.TSNodeLabel;
import util.ArgumentReader;
import util.FileUtil;
import util.PrintProgress;
import util.Utility;

public class RetrieveGoodmanCounts
extends Thread {
    public static int numberOfTreesPerThreads = 50;
    File fragmentsFile;
    File outputFile;
    int threads;
    long fragmentReadCounter;
    long fragmentWrittenCounter;
    long currentIndex;
    PrintProgress progress;
    ArrayList<TSNodeLabel> treebank;
    ArrayList<TSNodeLabel> fragmentList;
    Hashtable<TSNodeLabel, double[]> finalFragmentsCount;
    Iterator<TSNodeLabel> treeIterator;

    public RetrieveGoodmanCounts(ArrayList<TSNodeLabel> treebank, File fragmentsFile, File outputFile, int threads) {
        this.treebank = treebank;
        this.fragmentsFile = fragmentsFile;
        this.outputFile = outputFile;
        this.threads = threads;
        this.treeIterator = treebank.iterator();
    }

    @Override
    public void run() {
        try {
            this.getFragmentList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.retriveGoodmanCounts();
        this.writeFragmentsToFile();
    }

    private void getFragmentList() throws Exception {
        Parameters.reportLine("Extracting fragments from file: " + this.fragmentsFile);
        this.progress = new PrintProgress("Progress:", 10000, 0);
        Scanner fragmentsScanner = FileUtil.getScanner(this.fragmentsFile);
        this.fragmentList = new ArrayList();
        while (fragmentsScanner.hasNextLine()) {
            this.progress.next();
            String line = fragmentsScanner.nextLine();
            if (line.equals("")) continue;
            String[] lineSplit = line.split("\t");
            TSNodeLabel fragment = new TSNodeLabel(lineSplit[0], false);
            this.fragmentList.add(fragment);
        }
        this.progress.end();
        Parameters.reportLine("Extracted fragments: " + this.fragmentList.size());
    }

    public void retriveGoodmanCounts() {
        this.finalFragmentsCount = new Hashtable();
        Parameters.reportLineFlush("Retrieving Goodman Counts");
        this.progress = new PrintProgress("Extracting from tree:", numberOfTreesPerThreads, 0);
        try {
            if (this.threads == 1) {
                this.updateTableWithFragmCounts(this.finalFragmentsCount, this.treebank);
            } else {
                this.startMultiThreads();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.progress.end();
    }

    private void updateTableWithFragmCounts(Hashtable<TSNodeLabel, double[]> tableToUpdate, ArrayList<TSNodeLabel> trees) {
        for (TSNodeLabel tree : trees) {
            Hashtable treeFragmentCount = new Hashtable();
            int totalCountsInTree = 0;
            for (TSNodeLabel tSNodeLabel : this.fragmentList) {
                int count = tree.countRecursiveFragment(tSNodeLabel);
                if (count <= 0) continue;
                totalCountsInTree += count;
                Utility.increaseInTableInt(treeFragmentCount, tSNodeLabel, count);
            }
            for (Map.Entry entry : treeFragmentCount.entrySet()) {
                TSNodeLabel fragment = (TSNodeLabel)entry.getKey();
                double ratio = (double)((int[])entry.getValue())[0] / (double)totalCountsInTree;
                Utility.increaseInTableDoubleArray(tableToUpdate, fragment, ratio);
            }
        }
    }

    private void startMultiThreads() throws Exception {
        CountFragmentsThread[] threadsArray = new CountFragmentsThread[this.threads];
        int lastThreadIndex = this.threads - 1;
        int t = 0;
        while (t < this.threads) {
            CountFragmentsThread newCounterThread;
            threadsArray[t] = newCounterThread = new CountFragmentsThread();
            if (t == lastThreadIndex) {
                newCounterThread.run();
            } else {
                newCounterThread.start();
            }
            ++t;
        }
        int i = 0;
        while (i < lastThreadIndex) {
            try {
                threadsArray[i].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void writeFragmentsToFile() {
        Parameters.reportLine("Printing fragments with new counts to file: " + this.outputFile);
        PrintWriter pw = FileUtil.getPrintWriter(this.outputFile);
        for (Map.Entry<TSNodeLabel, double[]> e : this.finalFragmentsCount.entrySet()) {
            TSNodeLabel fragment = e.getKey();
            double count = e.getValue()[0];
            pw.println(String.valueOf(fragment.toString(false, true)) + "\t" + count);
        }
        pw.close();
    }

    private synchronized ArrayList<TSNodeLabel> getNextTreeLoad() {
        if (!this.treeIterator.hasNext()) {
            return null;
        }
        ArrayList<TSNodeLabel> treesForThread = new ArrayList<TSNodeLabel>(numberOfTreesPerThreads);
        int i = 0;
        while (this.treeIterator.hasNext()) {
            if (i == numberOfTreesPerThreads) break;
            treesForThread.add(this.treeIterator.next());
            ++i;
        }
        this.progress.next(i);
        return treesForThread;
    }

    private synchronized void addFragmentsToFinalTable(Hashtable<TSNodeLabel, double[]> threadFragmentCount) {
        for (Map.Entry<TSNodeLabel, double[]> e : threadFragmentCount.entrySet()) {
            TSNodeLabel fragment = e.getKey();
            Utility.increaseInTableDoubleArray(this.finalFragmentsCount, fragment, e.getValue()[0]);
        }
    }

    public static void main(String[] args) throws Exception {
        long time = System.currentTimeMillis();
        String usage = "USAGE: java RetrieveGoodamnCounts [-threads:1] treebankFile fragmentsFile outputFile";
        String threadsOption = "-threads:";
        int threads = 1;
        int length = args.length;
        if (length < 3 || length > 4) {
            System.err.println("Incorrect number of arguments");
            System.err.println(usage);
            return;
        }
        File treebankFile = null;
        File inputFile = null;
        File outputFile = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            if (option.startsWith(threadsOption)) {
                threads = ArgumentReader.readIntOption(option);
            } else if (treebankFile == null) {
                treebankFile = new File(option);
            } else if (inputFile == null) {
                inputFile = new File(option);
            } else {
                outputFile = new File(option);
            }
            ++n2;
        }
        if (!treebankFile.exists()) {
            System.err.println("Treebank File does not exist");
            System.err.println(usage);
            return;
        }
        if (!inputFile.exists()) {
            System.err.println("Input File does not exist");
            System.err.println(usage);
            return;
        }
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(treebankFile);
        RetrieveGoodmanCounts RCF = new RetrieveGoodmanCounts(treebank, inputFile, outputFile, threads);
        RCF.run();
        System.out.println("Took: " + (System.currentTimeMillis() - time) / 1000L + "seconds.");
    }

    private class CountFragmentsThread
    extends Thread {
        private CountFragmentsThread() {
        }

        @Override
        public void run() {
            ArrayList treeLoad = null;
            while ((treeLoad = RetrieveGoodmanCounts.this.getNextTreeLoad()) != null) {
                Hashtable threadFragmentCount = new Hashtable();
                RetrieveGoodmanCounts.this.updateTableWithFragmCounts(threadFragmentCount, treeLoad);
                RetrieveGoodmanCounts.this.addFragmentsToFinalTable(threadFragmentCount);
            }
        }
    }
}

