

import os
import sys
import json
import click


from datetime import datetime

# sys.path.append('../../emnlp_eval')
# sys.path.append('../../baselines/tinystyle')
# sys.path.append('../../inference')


# from classifiers import load_style_model, text_to_style

from tinystyle_generate_formal_informal import load_style_tasks



def main():
    args = {
            'out_dir': 'baseline_copy',
            'model_name': 'copy',
            'path_to_formal_input': '/home///gyafc/data/GYAFC_Corpus 2/Entertainment_Music/test/formal',
            'path_to_informal_input': '/home///gyafc/data/GYAFC_Corpus 2/Entertainment_Music/test/informal',
    }

    cur_date  = datetime.now().strftime('%Y-%m-%d-%H_%M_%S')
    args['out_dir'] = os.path.join(args['out_dir'], cur_date)
    os.makedirs(args['out_dir'], exist_ok=True)

    formal_to_informal_tasks = load_style_tasks(args['path_to_formal_input'], target_label='informal')
    for task in formal_to_informal_tasks:
        task['output'] = [task['source_text']]
    informal_to_formal_tasks = load_style_tasks(args['path_to_informal_input'], target_label='formal')
    for task in informal_to_formal_tasks:
        task['output'] = [task['source_text']]

    with open(os.path.join(args['out_dir'], 'args.json'), 'w') as f:
        json.dump(args, f, indent=2)

    with open(os.path.join(args['out_dir'], 'to_informal.jsonl'), 'w') as f:
        for task in formal_to_informal_tasks:
            f.write(json.dumps(task) + '\n')
        
    with open(os.path.join(args['out_dir'], 'to_formal.jsonl'), 'w') as f:
        for task in informal_to_formal_tasks:
            
            f.write(json.dumps(task) + '\n')

if __name__ == '__main__':
    main()


