prompt_len=20
prompt_config='configs/config_prompt_p20.json'
batch_size_pt=32
batch_size_ft=16

for seed in {42..44}
do 
  ### baseline1: finetuning
  for t in 'boolq' 'cb' 'copa' 'mrc' 'srte' 'wic' 'snli' 'paws' 'imdb'
  do 
    echo task: $t config: ./configs/Target/${t}.yaml
    python -m torch.distributed.launch --nproc_per_node=8 --use_env train_t5.py \
          --task $t \
          --config ./configs/Target/${t}.yaml \
          --output_dir output/t5_base/p$prompt_len/seed$seed/Target_100shot/$t/finetuning \
          --text_encoder t5-base \
          --batch_size_train $batch_size_ft \
          --batch_size_test $batch_size_ft \
          --seed $seed \
          --dataset_root /data/Datasets/public_data/text2text_100shot
  done

  ### baseline3: vanilla prompt tuning
  for t in 'boolq' 'cb' 'copa' 'mrc' 'srte' 'wic' 'snli' 'paws' 'imdb'
  do 
    echo task: $t config: ./configs/Target/${t}_prompt.yaml
    python -m torch.distributed.launch --nproc_per_node=8 --use_env train_t5.py \
          --task $t \
          --config ./configs/Target/${t}_prompt.yaml \
          --output_dir output/t5_base/p$prompt_len/seed$seed/Target_100shot/$t/prompt_tuning \
          --use_prompt \
          --only_prompt \
          --text_encoder t5-base \
          --seed $seed \
          --batch_size_train $batch_size_pt \
          --batch_size_test $batch_size_pt \
          --prompt_config $prompt_config \
          --dataset_root /data/Datasets/public_data/text2text_100shot
  done

  ### baseline4: multitask prompt tuning as initialization
  for t in 'boolq' 'cb' 'copa' 'mrc' 'srte' 'wic' 'snli' 'paws' 'imdb'
  do 
    echo task: $t config: ./configs/Target/${t}_prompt.yaml
    python -m torch.distributed.launch --nproc_per_node=8 --use_env train_t5.py \
           --task $t \
           --config ./configs/Target/${t}_prompt.yaml \
           --output_dir output/t5_base/p$prompt_len/seed$seed/Target_100shot/$t/prompt_tuning_mpt \
           --checkpoint output/t5_base/p$prompt_len/seed$seed/multitask/prompt_tuning/checkpoint_best.pth \
           --use_prompt \
           --only_prompt \
           --text_encoder t5-base \
           --seed $seed \
           --batch_size_train $batch_size_pt \
           --batch_size_test $batch_size_pt \
           --prompt_config $prompt_config \
           --dataset_root /data/Datasets/public_data/text2text_100shot
  done

  ### BiKT_PT: prompt tuning on feedback model
  for t in 'boolq' 'cb' 'copa' 'mrc' 'srte' 'wic' 'snli' 'paws' 'imdb'
  do 
    echo task: $t config: ./configs/Target/${t}_prompt.yaml
    python -m torch.distributed.launch --nproc_per_node=8 --use_env train_t5.py \
           --task $t \
           --config ./configs/Target/${t}_prompt.yaml \
           --output_dir output/t5_base/p$prompt_len/seed$seed/Target_100shot/$t/prompt_tuning_bikt \
           --checkpoint output/t5_base/p$prompt_len/seed$seed/multitask/bikt/checkpoint_best.pth \
           --use_prompt \
           --only_prompt \
           --text_encoder t5-base \
           --seed $seed \
           --batch_size_train $batch_size_pt \
           --batch_size_test $batch_size_pt \
           --prompt_config $prompt_config \
           --dataset_root /data/Datasets/public_data/text2text_100shot
  done

  ### BiKT_PT: prompt tuning (averaged) on feedback model
  for t in 'boolq' 'cb' 'copa' 'mrc' 'srte' 'wic' 'snli' 'paws' 'imdb'
  do 
    echo task: $t config: ./configs/GLUE/${t}_prompt.yaml class_num
    python -m torch.distributed.launch --nproc_per_node=8 --use_env train_t5.py \
           --task $t \
           --config ./configs/Target/${t}_prompt.yaml \
           --output_dir output/t5_base/p$prompt_len/seed$seed/Target_100shot/$t/prompt_tuning_bikt_average \
           --checkpoint output/t5_base/p$prompt_len/seed$seed/multitask/bikt/checkpoint_merged_prompt.pth \
           --use_prompt \
           --only_prompt \
           --text_encoder t5-base \
           --seed $seed \
           --batch_size_train $batch_size_pt \
           --batch_size_test $batch_size_pt \
           --prompt_config $prompt_config \
           --dataset_root /data/Datasets/public_data/text2text_100shot
  done

  ### BiKT_PT: prompt tuning (weighted averaged) on feedback model
  for t in 'boolq' 'cb' 'copa' 'mrc' 'srte' 'wic' 'snli' 'paws' 'imdb'
  do 
    echo task: $t config: ./configs/GLUE/${t}_prompt.yaml class_num
    python -m torch.distributed.launch --nproc_per_node=8 --use_env train_t5.py \
           --task $t \
           --config ./configs/Target/${t}_prompt.yaml \
           --output_dir output/t5_base/p$prompt_len/seed$seed/Target_100shot/$t/prompt_tuning_bikt_weighted_average \
           --checkpoint output/t5_base/p$prompt_len/seed$seed/multitask/bikt/checkpoint_weighted_merged_prompt.pth \
           --use_prompt \
           --only_prompt \
           --text_encoder t5-base \
           --seed $seed \
           --batch_size_train $batch_size_pt \
           --batch_size_test $batch_size_pt \
           --prompt_config $prompt_config \
           --dataset_root /data/Datasets/public_data/text2text_100shot
  done

  ### BiKT without prompt: prompt tuning on feedback model (without prompt)
  for t in 'boolq' 'cb' 'copa' 'mrc' 'srte' 'wic' 'snli' 'paws' 'imdb'
  do 
    echo task: $t config: ./configs/Target/${t}_prompt.yaml
    python -m torch.distributed.launch --nproc_per_node=8 --use_env train_t5.py \
           --task $t \
           --config ./configs/Target/${t}_prompt.yaml \
           --output_dir output/t5_base/p$prompt_len/seed$seed/Target_100shot/$t/prompt_tuning_bikt_ablation \
           --checkpoint output/t5_base/p$prompt_len/seed$seed/multitask/finetuning/checkpoint_best.pth \
           --text_encoder t5-base \
           --use_prompt \
           --only_prompt \
           --seed $seed \
           --batch_size_train $batch_size_pt \
           --batch_size_test $batch_size_pt \
           --prompt_config $prompt_config \
           --dataset_root /data/Datasets/public_data/text2text_100shot
  done
done