/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class Alignment {
    private Map<IndexedWord, IndexedWord> map;
    protected double score;
    private String justification;

    public Alignment(Map<IndexedWord, IndexedWord> map, double score, String justification) {
        this.map = map;
        this.score = score;
        this.justification = justification;
    }

    public double getScore() {
        return this.score;
    }

    public Map<IndexedWord, IndexedWord> getMap() {
        return this.map;
    }

    public String getJustification() {
        return this.justification;
    }

    public String toString() {
        return this.toString("readable");
    }

    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        if (format == "readable") {
            ArrayList<IndexedWord> keys = new ArrayList<IndexedWord>(this.map.keySet());
            Collections.sort(keys);
            for (IndexedWord key : keys) {
                sb.append(String.format("%-20s ==> %s%n", Alignment.iwToString(key), Alignment.iwToString(this.map.get(key))));
            }
            sb.append(String.format("%s %6.3f%n", "Alignment score:", this.score));
        } else if (format == "readable-tag-index") {
            ArrayList<IndexedWord> keys = new ArrayList<IndexedWord>(this.map.keySet());
            Collections.sort(keys);
            for (IndexedWord key : keys) {
                sb.append(String.format("%-20s ==> %s%n", Alignment.iwToString(key), Alignment.iwToString(this.map.get(key))));
            }
            sb.append(String.format("%s %6.3f%n", "Alignment score:", this.score));
        } else if (format == "readable-old") {
            for (Map.Entry<IndexedWord, IndexedWord> entry : this.map.entrySet()) {
                sb.append(String.format("%-20s ==> %s%n", Alignment.iwToString(entry.getKey()), Alignment.iwToString(entry.getValue())));
            }
            sb.append("Alignment score: ");
            sb.append(String.format("%6.3f", this.score));
            sb.append("\n");
        } else {
            sb.append(this.map.toString());
        }
        return sb.toString();
    }

    private static String iwToString(IndexedWord iw) {
        if (iw == null || iw.equals(IndexedWord.NO_WORD)) {
            return "_";
        }
        return iw.toString(CoreLabel.OutputFormat.VALUE);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Alignment)) {
            return false;
        }
        Alignment other = (Alignment)o;
        return ((Object)this.map).equals(other.map);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    Alignment patchedAlignment(SemanticGraph hypGraph, SemanticGraph txtGraph) {
        Map<IndexedWord, IndexedWord> patchedMap = Generics.newHashMap();
        Set<IndexedWord> txtVertexSet = txtGraph.vertexSet();
        for (IndexedWord o : hypGraph.vertexSet()) {
            IndexedWord vertex = o;
            if (this.map.containsKey(vertex) && txtVertexSet.contains(this.map.get(vertex))) {
                patchedMap.put(vertex, this.map.get(vertex));
                continue;
            }
            patchedMap.put(vertex, IndexedWord.NO_WORD);
        }
        return new Alignment(patchedMap, this.score, this.justification);
    }

    public static Alignment makeFromIndexArray(SemanticGraph txtGraph, SemanticGraph hypGraph, int[] indexes, double score, String justification) {
        if (txtGraph == null || txtGraph.isEmpty()) {
            throw new IllegalArgumentException("Invalid txtGraph " + txtGraph);
        }
        if (hypGraph == null || hypGraph.isEmpty()) {
            throw new IllegalArgumentException("Invalid hypGraph " + hypGraph);
        }
        if (indexes == null) {
            throw new IllegalArgumentException("Null index array");
        }
        if (indexes.length != hypGraph.size()) {
            throw new IllegalArgumentException("Index array length " + indexes.length + " does not match hypGraph size " + hypGraph.size());
        }
        Map<IndexedWord, IndexedWord> map = Generics.newHashMap();
        for (int i = 0; i < indexes.length; ++i) {
            IndexedWord hypNode = hypGraph.getNodeByIndex(i);
            IndexedWord txtNode = IndexedWord.NO_WORD;
            if (indexes[i] >= 0) {
                txtNode = txtGraph.getNodeByIndex(indexes[i]);
            }
            map.put(hypNode, txtNode);
        }
        return new Alignment(map, score, justification);
    }

    public static Alignment makeFromIndexArray(SemanticGraph txtGraph, SemanticGraph hypGraph, int[] indexes) {
        return Alignment.makeFromIndexArray(txtGraph, hypGraph, indexes, 0.0, null);
    }

    public static Alignment makeFromIndexArray(SemanticGraph txtGraph, SemanticGraph hypGraph, int[] indexes, double score) {
        return Alignment.makeFromIndexArray(txtGraph, hypGraph, indexes, score, null);
    }
}

