#!/bin/bash

home_dir="~/KP/generator"
export PYTHONPATH=${home_dir}:${PYTHONPATH}
# set CUDA_VISIBLE_DEVICES=1
export CUDA_VISIBLE_DEVICES=$1

data_dir="data/kp20k"

seed=27
dropout=0.1
learning_rate=0.0001
batch_size=24
copy_attention=true

max_kp_len=6
max_kp_num=20
loss_scale_pre=0.2
loss_scale_ab=0.1
set_loss=true
assign_steps=2
gpuid=$1
k_strategy="normal"
top_candidates=3
assign_temperature=10
loss_matching_scale=false

model_name="One2set"
data_args="Full"
main_args="Seed${seed}_Dropout${dropout}_LR${learning_rate}_BS${batch_size}_MaxLen${max_kp_len}\
_MaxNum${max_kp_num}_LossScalePre${loss_scale_pre}_LossScaleAb${loss_scale_ab}_Step${assign_steps}_KStrategy${k_strategy}_TopK${top_candidates}_AT${assign_temperature}"

if [ ${copy_attention} = true ] ; then
    model_name+="_Copy"
fi
if [ "${set_loss}" = true ] ; then
    main_args+="_SetLoss"
fi
if [ "${loss_matching_scale}" = true ] ; then
    main_args+="_LossMatchingScale"
fi

save_data="${data_dir}/${data_args}"
mkdir -p ${save_data}

exp="new_${data_args}_${model_name}_${main_args}"
train_out_dir="output/train/${exp}/"

echo "============================= test: ${exp} ================================="

beam_size=10

for beam_size in 10
do
for data in inspec krapivin semeval nus kp20k
do
  echo "============================= testing ${data} ================================="
  test_out_dir="data/${data}/test_beam${beam_size}"
  # test_out_dir=data/${data}/test_beam${beam_size}
  mkdir -p ${test_out_dir}

#   src_file="data/testsets/${data}/test_src.txt"
#   trg_file="data/testsets/${data}/test_trg.txt"
  src_file="data/${data}/test_src.txt"
  trg_file="data/${data}/test_trg.txt"

  # cmd="python -m debugpy --listen 5678 --wait-for-client predict.py \
  cmd="python predict.py \
  -vocab ${save_data} \
  -src_file=${src_file} \
  -pred_path ${test_out_dir} \
  -exp_path ${test_out_dir} \
  -model data/models/best_model.pt \
  -remove_title_eos \
  -batch_size 8 \
  -replace_unk \
  -dropout ${dropout} \
  -fix_kp_num_len \
  -one2many \
  -max_kp_len ${max_kp_len} \
  -max_kp_num ${max_kp_num} \
  -seperate_pre_ab \
  -use_optimal_transport \
  -k_strategy ${k_strategy} \
  -top_candidates ${top_candidates} \
  -assign_temperature ${assign_temperature} \
  -beam_size ${beam_size} \
  "
  # -load \
  # -prob_range ${prob_range} \
  # "
#   -score_threshold -1 \
#   "
  if [ "$copy_attention" = true ] ; then
      cmd+=" -copy_attention"
  fi
  if [ "${loss_matching_scale}" = true ] ; then
      cmd+=" -loss_matching_scale"
  fi

  echo $cmd
  eval $cmd

  cmd="python evaluate_prediction.py \
  -pred_file_path ${test_out_dir}/predictions.txt \
  -src_file_path ${src_file} \
  -trg_file_path ${trg_file} \
  -exp_path ${test_out_dir} \
  -export_filtered_pred \
  -filtered_pred_path ${test_out_dir} \
  -disable_extra_one_word_filter \
  -invalidate_unk \
  -all_ks 5 M \
  -present_ks 5 M \
  -absent_ks 5 M \
  ;cat ${test_out_dir}/results_log_5_M_5_M_5_M.txt
  "

  echo $cmd
  eval $cmd

  bash scripts-win-2/separate_test.sh $beam_size

done
done