theory question_66_2

imports Main

begin

typedecl entity

consts
  Sun :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  Planets :: "entity ⇒ bool"
  Stars :: "entity ⇒ bool"
  Earth :: "entity"
  Mars :: "entity"
  Moon :: "entity"
  Hotter :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: The Sun is a star. *)
axiomatization where
  explanation_1: "∀x. Sun x ⟶ Star x"

(* Explanation 2: Stars are hotter than planets. *)
axiomatization where
  explanation_2: "∀x y. Stars x ∧ Planets y ⟶ Hotter x y"

(* Explanation 3: The Sun is hotter than the Earth, Mars, and the Moon. *)
axiomatization where
  explanation_3: "∀x. Sun x ⟶ Hotter x Earth ∧ Hotter x Mars ∧ Hotter x Moon"

theorem hypothesis:
  assumes asm: "Sun x"
  (* Hypothesis: The Sun is the hottest among the Earth, Mars, and the Moon. *)
  shows "Hotter x Earth ∧ Hotter x Mars ∧ Hotter x Moon"
proof -
  from asm have "Star x" using explanation_1 by simp
  then have "Hotter x Earth ∧ Hotter x Mars ∧ Hotter x Moon" using explanation_3 by simp
  then show ?thesis by simp
qed

end
