theory question_61_5

imports Main

begin

typedecl entity

consts
  Star :: "entity ⇒ bool"
  TheSun :: "entity ⇒ bool"
  CentralBody :: "entity ⇒ entity ⇒ bool"
  Consists :: "entity ⇒ entity ⇒ bool"
  SolarSystemBody :: "entity ⇒ bool"
  SolarSystem :: "entity"

(* Explanation 1: If x is a star, then x is the sun. *)
axiomatization where
  explanation_1: "Star x ⟶ TheSun x"

(* Explanation 2: If x is the central body of the solar system, then x is the sun. *)
axiomatization where
  explanation_2: "CentralBody x SolarSystem ⟶ TheSun x"

(* Explanation 3: If the solar system consists of X and every solar system body is either an element of X or the sun, then x is an element of X. *)
axiomatization where
  explanation_3: "Consists SolarSystem X ∧ (∀y. SolarSystemBody y ↔ (y ∈ X ∨ y = TheSun)) ⟶ X x"

theorem hypothesis:
  assumes asm: "Star x"
  (* Hypothesis: If the sun is a star, then the sun is the largest body in the solar system. *)
  shows "CentralBody TheSun SolarSystem ∧ Consists SolarSystem {TheSun} ∧  ∀y. SolarSystemBody y ↔  y ∈ {TheSun} ∨ y = TheSun  "
proof -
  have "TheSun x" using asm by (rule explanation_1)
  then have "CentralBody TheSun SolarSystem" by (rule explanation_2)
  have "Consists SolarSystem {TheSun} ∧ (∀y. SolarSystemBody y ↔  y ∈ {TheSun} ∨ y = TheSun)" by simp
qed

end
