theory question_83_2
imports Main

begin

typedecl entity
typedecl event

consts
  Computers :: "entity ⇒ bool"
  Run :: "entity ⇒ event ⇒ bool"
  electricalCircuit :: "entity ⇒ entity"
  WorkingProperly :: "event ⇒ entity ⇒ bool"  (* changed type of second operand from "event" to "entity" *)

theorem hypothesis:
  assumes asm: "Computers x ∧ WorkingProperly e  electricalCircuit x "  (* changed usage of WorkingProperly to match new type *)
  (* Hypothesis: Computers run when electrical circuit is working properly. *)
  shows "Run x e"
proof -
  from asm have "WorkingProperly e (electricalCircuit x)" by simp
  then have "electricalCurrentFlowsThrough (electricalCircuit x) e" using explanation_1 by blast
  then have "Run x e" using explanation_2 by blast
  then show ?thesis using asm `x` `e` by blast
qed

end
