theory question_31_0
imports Main

begin

typedecl entity
typedecl event

consts
  Object :: "entity ⇒ bool"
  Shape :: "entity ⇒ bool"
  Sharpening :: "event ⇒ bool"
  ChangeShape :: "entity ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  ElectricSharpener :: "entity ⇒ bool"
  Metal :: "entity ⇒ bool"
  Remove :: "event ⇒ bool"
  TooMuch :: "entity ⇒ bool"
  Waves :: "entity ⇒ bool"
  Causes :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Sharpening an object causes that object to change shape. *)
axiomatization where
  explanation_1: "∀x y e. Object x ∧ Shape y ∧ Sharpening e ∧ Agent e x ⟶ ChangeShape x (the (entity) y)"

(* Explanation 2: An electric sharpener removes too much metal and often causes waves. *)
axiomatization where
  explanation_2: "∀x y z. ElectricSharpener x ∧ Metal y ∧ (∃e. Remove e ∧ Agent e x ∧ Patient e y ∧ TooMuch y) ⟶ Waves z ∧ Causes (the (event) e) z"

theorem hypothesis:
  assumes asm: "Object x ∧ Shape y ∧ Material z"
  (* Hypothesis: One way an object's shape can be changed is by removing material. *)
  shows "ChangeShape x y ∧  ∃e. Remove e ∧ Agent e x ∧ Patient e z "
proof -
  from asm have mat: "Material z" by simp
  have "Object x" "Shape y" using asm by simp+
  then have "ChangeShape x (the (entity) y)"
    using explanation_1 by (blast dest: change_shape_dest)
  then have "∃e. Remove e ∧ Agent e x ∧ Patient e (the (entity) z)"
    using explanation_2 mat by (blast dest: remove_material_dest)
  then show ?thesis ..
qed

end
