theory question_30_6
imports Main

begin

typedecl entity
typedecl event

consts
  Friendship :: "entity ⇒ bool"
  InitiationOfCourtshipBehavior :: "entity ⇒ bool"
  Precede :: "entity ⇒ entity ⇒ bool"
  Attract :: "entity ⇒ entity ⇒ bool"
  AttractingMate :: "entity ⇒ bool"

(* Explanation 1: Friendship usually precedes the initiation of courtship behavior. *)
axiomatization where
  explanation_1: "∀x y. Friendship x ∧ InitiationOfCourtshipBehavior y ⟶ Precede x y"

(* Explanation 2: The initiation of courtship behavior directly results in attracting a mate. *)
axiomatization where
  explanation_2: "∀x y. InitiationOfCourtshipBehavior x ⟶ (∃e. Attract e x y)"  (* fixed: changed type of y to entity *)

theorem hypothesis:
  assumes asm: "Friendship x ∧ AttractingMate y"
  (* Hypothesis: Friendship usually precedes attracting a mate. *)
  shows "Precede x y"
proof -
  from asm have "Friendship x" and "AttractingMate y" by simp_all
  then obtain z where z: "InitiationOfCourtshipBehavior z" using explanation_2 by blast
  have "Precede x z" using z explanation_1 by blast
  have "Attract z y" using z by blast
  have "Precede x y" using `Precede x z` `Attract z y` by (rule Precede_trans)
  show ?thesis using `Precede x y` by simp
qed

end
