theory question_56_0

imports Main

begin

typedecl entity
typedecl event

consts
  Men :: "entity ⇒ bool"
  Two :: "entity ⇒ bool"
  Tanned :: "entity ⇒ bool"
  Shorts :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  FishingNet :: "entity ⇒ bool"
  BeachShore :: "entity ⇒ bool"
  Along :: "entity ⇒ entity ⇒ entity ⇒ bool"
  Pulling :: "event ⇒ bool"

theorem hypothesis:
  (* Premise: Two tanned men wearing shorts are pulling a fishing net along a beach shore. *)
  assumes asm: "Men x ∧ Two x ∧ Tanned x ∧ Shorts y ∧ Wearing x y ∧ FishingNet z ∧ BeachShore l ∧ Along x l z ∧ Pulling e ∧ Agent e x ∧ Patient e z"
  (* Hypothesis: The men are on the beach. *)
  shows "∃x. Men x ∧ Beach l ∧ On x l"
proof -
  from asm have "BeachShore l" by auto
  then have "Beach l" by simp
  from asm have "Men x" by auto
  then have "On x l" using asm by blast
  show ?thesis using `Men x` `Beach l` by blast
qed

end

