theory question_51_1
imports Main

begin
typedecl entity
typedecl event

consts
  Speech :: "event ⇒ bool"
  PublicSpeaking :: "event ⇒ bool"
  Man :: "entity ⇒ bool"
  Giving :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Party :: "entity ⇒ bool"
  OrnateCostumeParty :: "entity ⇒ bool"
  PublicEvent :: "entity ⇒ bool"
  At :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A speech is a form of public speaking. *)
axiomatization where
  explanation_1: "∀e. Speech e ⟶ PublicSpeaking e"

(* Explanation 2: A man giving a speech is equivalent to the man public speaking. *)
axiomatization where
  explanation_2: "∀x e1 e2. Man x ∧ Giving e1 ∧ Agent e1 x ∧ Speech e2 ∧ Patient e1 e2 ⟷ PublicSpeaking e1 ∧ Agent e1 x"

(* Explanation 3: A party is a public event. *)
axiomatization where
  explanation_3: "∀z. Party z ⟶ PublicEvent z"

(* Explanation 4: Giving a speech at a party implies public speaking. *)
axiomatization where
  explanation_4: "∀x z e1 e2. Man x ∧ Party z ∧ Giving e1 ∧ Agent e1 x ∧ Speech e2 ∧ Patient e1 e2 ∧ At e1 z ⟶ PublicSpeaking e1 ∧ Agent e1 x"

theorem hypothesis:
  (* Premise: A man gives a speech at an ornate costume party. *)
  assumes asm: "Man x ∧ OrnateCostumeParty z ∧ Giving e1 ∧ Agent e1 x ∧ Speech e1 ∧ At e1 z"
  (* Hypothesis: A man is public speaking. *)
  shows "∃x e. Man x ∧ PublicSpeaking e ∧ Agent e x"
proof -
  from asm have "Man x ∧ Giving e1 ∧ Agent e1 x ∧ Speech e1" by blast
  then have "PublicSpeaking e1 ∧ Agent e1 x" using explanation_2 by blast
  then show ?thesis using asm `Man x` `PublicSpeaking e1` `Agent e1 x` by blast
qed

end
