theory question_30_0

imports Main

begin

typedecl entity
typedecl event

consts
 Courtship :: "entity ⇒ bool"
 Intended :: "event ⇒ bool"
 Attract :: "event ⇒ bool"
 Friendship :: "entity ⇒ bool"
 Precedes :: "event ⇒ event ⇒ bool"
 Marriage :: "entity ⇒ bool"

(* Explanation 1: Courtship is behavior that is intended to attract a mate. *)
axiomatization where
 explanation_1: "∀x y e1 e2. Courtship x ∧ Intended e1 ∧ Attract e2 ∧ Agent e1 x ∧ Patient e1 y ∧ Agent e2 x ∧ Patient e2 y"

(* Explanation 2: Friendship usually precedes courtship, and courtship, marriage. *)
axiomatization where
 explanation_2: "∀x y e1 e2 e3. Friendship x ∧ Precedes e1 Courtship y ∧ Marriage z ∧ Agent e1 x ∧ Patient e1 y ∧ Agent e2 y ∧ Patient e2 z ∧ Agent e3 z ∧ Patient e3 x"

theorem hypothesis:
 assumes asm: "Friendship x  ∧ Precedes e1  ∧ AttractingMate e2  ∧ Agent e1  x  ∧ Patient e1  y  ∧ Agent e2  x  ∧ Patient e2  y "
 (* Hypothesis: Friendship usually precedes attracting a mate. *)
 shows "∃x y e1 e2 e3. Friendship x ∧ Precedes e1 Courtship y ∧ Marriage z ∧ Agent e1 x ∧ Patient e1 y ∧ Agent e2 y ∧ Patient e2 z ∧ Agent e3 z ∧ Patient e3 x"
proof -
 from asm have "Friendship x" by simp
 then obtain e1 where e1: "Precedes e1 Courtship y" using explanation_2 by blast
 then have "Courtship y" using explanation_1 by blast
 have conclusion: "Precedes e1 Courtship y" using e1 by simp
 show ?thesis using asm conclusion `Courtship y` by blast
qed

end
