theory question_86_8
```
imports Main

begin

typedecl entity
typedecl event

consts
 Woman :: "entity ⇒ bool"
 Converse :: "event ⇒ bool"
 Talking :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 Patient :: "event ⇒ entity ⇒ bool"
 ThreeWomen :: "entity ⇒ bool"
 Table :: "entity ⇒ bool"
 Drinks :: "entity ⇒ bool"

(* Explanation 1: When women converse, they are talking. *)
axiomatization where
 explanation_1: "∀x y. Woman x ∧ Converse y ⟶ Talking y"

(* Explanation 2: Women are talking when they converse. *)
axiomatization where
 explanation_2: "∀x y e. Woman x ∧ Converse y ∧ Talking e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
 (* Premise: There are three women conversing at a table with drinks. *)
 assumes asm: "ThreeWomen x  ∧ Conversing y  ∧ Table z  ∧ Drinks z  ∧ Agent e  x  ∧ In e  z "
 (* Hypothesis: Women are talking. *)
 shows "∃x y e. Woman x  ∧ Talking e  ∧ Agent e  x "
proof -
 from asm have "ThreeWomen x" by blast
 then have " Woman x" using explanation_1 by blast
 then have "Converse y" using explanation_2 by blast
 then have "Talking e" using explanation_1 by blast
 then show ?thesis using `Woman x` `Converse y` `Talking e` by blast
qed.

end