theory question_35_0

imports Main

begin

typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  Cellphone :: "entity ⇒ bool"
  Talking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Red :: "entity ⇒ bool"
  BicycleHelmet :: "entity ⇒ bool"
  Background :: "entity ⇒ bool"
  OtherPeople :: "entity ⇒ bool"

(* Explanation 1: A man talking on a cellphone talks on a cellphone. *)
axiomatization where
  explanation_1: "∀x e. Man x ∧ Cellphone e ∧ Talking e ∧ Agent e x"

theorem hypothesis:
  (* Premise: A man wearing a red bicycle helmet talking on a cellphone with other people in the background. *)
  assumes asm: "Man x ∧ Cellphone e ∧ Talking e ∧ Agent e x ∧ Wearing x y ∧ Red y ∧ BicycleHelmet y ∧ Background z ∧ OtherPeople z"
  (* Hypothesis: A man talks on a cellphone. *)
  shows "∃x e. Man x ∧ Cellphone e ∧ Talking e ∧ Agent e x"
proof -
  from asm have "Man x" by blast
  from this have "Cellphone e" using explanation_1 by blast
  from asm have "Talking e" by blast
  show ?thesis using `Man x` `Cellphone e` `Talking e` by blast
qed

end
