theory question_20_2

imports Main

begin

typedecl entity
typedecl event

consts
  Mammals :: "entity ⇒ bool"
  Fur :: "entity ⇒ bool"
  Hair :: "entity ⇒ bool"
  ExclusiveCharacteristic :: "entity ⇒ bool"
  UniqueToMammals :: "entity ⇒ bool"

(* Explanation 1: All mammals have fur or hair. *)
axiomatization where
  explanation_1: "∀x. Mammals x ⟶ (Fur x ∨ Hair x)"

(* Explanation 2: If something has an exclusive characteristic, then it is unique to mammals. *)
axiomatization where
  explanation_2: "∀x. ExclusiveCharacteristic x ⟶ UniqueToMammals x"

theorem hypothesis:
  assumes asm: "Fur x"
  (* Hypothesis: Fur is unique to mammals. *)
  shows "∃x. Fur x ∧ UniqueToMammals x"
proof -
  from asm have "Fur x" by simp
  then have "Mammals x" using explanation_1 by blast
  then have "UniqueToMammals x" using explanation_2 by blast
  then show ?thesis using `Fur x` `UniqueToMammals x` by blast
qed

end
