theory question_46_0

imports Main

begin
typedecl entity
typedecl event

consts
  Boy :: "entity ⇒ bool"
  Sells :: "event ⇒ bool"
  StreetCart :: "event ⇒ bool"
  StreetVendor :: "entity ⇒ bool"
  OrangeShirt :: "entity ⇒ bool"

(* Explanation 1: If the boy sells fruit from a street cart, he is a street vendor. *)
axiomatization where
  explanation_1: "∀x e. Boy x ∧ Sells e ∧ StreetCart e ⟶ StreetVendor x"

theorem hypothesis:
  (* Premise: A boy in an orange shirt sells fruit from a street cart. *)
  assumes asm: "Boy x ∧ OrangeShirt y ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ StreetCart e"
  (* Hypothesis: A boy is a street vendor. *)
  shows "∃x. Boy x ∧ StreetVendor x"
proof -
  from asm have "Boy x ∧ Sells e ∧ StreetCart e" by blast
  then have "StreetVendor x" using explanation_1 by blast
  then show ?thesis using `Boy x` by blast
qed

end
