#!/usr/bin/env bash
echo usage: 
echo scriptName.sh : run in normal mode
echo scriptName.sh debug : run in debug mode

# hardware
cudaID=$2

# debug mode
if [[ $# != 0 ]] && [[ $1 == "debug" ]]
then
    debug=true
else
    debug=false
fi

seed=1

# dataset
dataDir='bank77'
targetDomain="BANKING"
# dataDir=HINT3
# targetDomain='curekart,powerplay11,sofmattress'
# dataDir=OOS
# targetDomain='travel,kitchen_dining'
# dataDir=hwu64_publishedPaper
# targetDomain='play,lists,recommendation,iot,general,transport,weather,social,email,music,qa,takeaway,audio,news,datetime,calendar,cooking,alarm'
beforeBatchNorm=--beforeBatchNorm

# setting
way=5
shot=2
shotList=(2)

# model initialization
# LMName=intent-bert-base-uncased
# LMName=joint-intent-bert-base-uncased-bank77
# LMName=joint-intent-bert-base-uncased-mcid
# LMName=joint-intent-bert-base-uncased-hint3
# LMName=ST_multi-class_utility,auto_commute,kitchen_dining,work,home,meta,small_talk,travel
LMNameList=(syn0_seed1_lossCovWeight0.04_valtravel,kitchen_dining syn0_seed2_lossCovWeight0.04_valtravel,kitchen_dining syn0_seed3_lossCovWeight0.04_valtravel,kitchen_dining syn0_seed4_lossCovWeight0.04_valtravel,kitchen_dining syn0_seed5_lossCovWeight0.04_valtravel,kitchen_dining)

# modify arguments if it's debug mode
RED='\033[0;31m'
GRN='\033[0;32m'
NC='\033[0m' # No Color
if $debug
then
    echo -e "Run in ${RED} debug ${NC} mode."
    epochs=1
else
    echo -e "Run in ${GRN} normal ${NC} mode."
fi

echo "Start Experiment ..."
for shot in ${shotList[@]}
do
    for LMName in ${LMNameList[@]}
    do
        logFolder=./log/
        mkdir -p ${logFolder}
        logFile=${logFolder}/eval_${dataDir}_to_${targetDomain}_${way}way_${shot}shot_LM${LMName}.log
        if $debug
        then
            logFlie=${logFolder}/logDebug.log
        fi

        export CUDA_VISIBLE_DEVICES=${cudaID}
        python eval.py \
            --seed ${seed} \
            --targetDomain ${targetDomain} \
            --dataDir ${dataDir} \
            --shot ${shot}  \
            --LMName ${LMName} \
            ${beforeBatchNorm}  \
            | tee "${logFile}"
        done
    done
echo "Experiment finished."
