from ..supertag import LexicalRule, Supertag, str_or_repr


def test_lexical_rule():
    r = LexicalRule("A;B;C;0*1:0")
    assert str(r) == "A -> [x0 * y0, x1] (B, C)"
    assert list(r.discodop_rules("TAG")) == [
        (("A", "B", "TAG-SPLIT"), ((0, 1), (0,))),
        (("TAG-SPLIT", "C", "TAG"), ((1, 0),)),
        (("TAG", "Epsilon"), (" ",))
    ]

def test_supertag():
    r = LexicalRule("A;B;C;0*1:0")
    t = Supertag(r, 1, "A", "pos")
    tag = "Supertag{LexicalRule{A,B,C,0*1:0},1,A,pos}"
    assert t.str_tag() == tag
    assert list(t.discodop_rules()) == [
        (("A", "B", f"{tag}-SPLIT"), ((0, 1), (0,))),
        ((f"{tag}-SPLIT", "C", tag), ((1, 0),)),
        ((tag, "Epsilon"), (" ",))
    ]
    assert Supertag(r, 1, "A", "pos") == Supertag(r, 1, "A", "pos")

    assert t.split("constituent") == (Supertag(r, 1, None, "pos"), "A")
    assert t.split("pos") == (Supertag(r, 1, "A", None), "pos")
    assert t.split("constituent", "pos") == (Supertag(r, 1, None, None), "A", "pos")
    assert ", ".join(str_or_repr(c) for c in t.split("constituent", "pos")) == "Supertag{LexicalRule{A,B,C,0*1:0},1}, A, pos"