from sentence import Sentence
from typing import List


class Instance:
    """
    This class is the basic Instance for a datasample
    """

    def __init__(self, input: Sentence, event: str = None, title: str = None, output: List[str] = None, target: List[str] = None) -> None:
        """
        Constructor for the instance.
        :param input: sentence containing the words
        :param output: a list of labels
        """
        self.input = input
        self.event = event
        self.title = title
        self.output = output
        self.sent_ids = None
        self.char_ids = None
        self.output_ids = None
        self.vec = None
        self.target = target

    def __len__(self):
        return len(self.input)