"""Prepare training arguments."""



from transformers import Seq2SeqTrainingArguments



def prepare_training_arguments(args):
    train_args = Seq2SeqTrainingArguments(
        output_dir=args.run_dir, 
        do_train=args.do_train,     # True
        do_eval=args.do_eval,       # True
        evaluation_strategy='epoch', 
        logging_steps=args.logging_steps,   
        # optimization args, the trainer uses the Adam optimizer 
        # and has a linear warmup for the learning rates
        per_device_train_batch_size=args.per_device_train_batch_size,     # 32
        per_device_eval_batch_size=args.per_device_eval_batch_size,       # 32
        gradient_accumulation_steps=args.gradient_accumulation_steps,     # 1
        learning_rate=args.learning_rate, 
        num_train_epochs=args.num_train_epochs, 
        warmup_steps=args.warmup_steps, 
        # misc args
        seed=args.seed, 
        disable_tqdm=False, 
        load_best_model_at_end=True, 
        metric_for_best_model='bleu-4', 
        # generation
        predict_with_generate=True
    )
    return train_args

