
# Parallel Instance Query Network for Nested Named Entity Recognition

This is supplementary material to our submission "Parallel Instance Query Network for Nested Named Entity Recognition". We will make all code publicly available upon acceptance.

## Setup

```bash
conda create -n acl2022 python=3.8
conda activate acl2022
pip install -r requirements.txt
mkdir -p data/datasets
# place the datasets into data/datasets
```

## Dataset

Due to the dataset license, we cannot directly release the ACE04, ACE05 and KBP17 datasets. To validate our code, we provide the pre-processed GENIA dataset as an example. Please place `genia` in the `/data/datasets` directory and follow the instructions below.

## Training

```bash
python piqn.py train --config configs/example.conf
```

## Evaluation

Set `model_path` of `eval.conf` to the path of the model checkpoint, then run:

```bash
python piqn.py eval --config configs/eval.conf
```