/*
 * Decompiled with CFR 0.152.
 */
package text_categorization;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import text_categorization.TextCategorizerFingerprint;
import utils_bk.FileUtils;

public class TextCategorizer {
    private static final int MIN_WORDS_4_CATEGORIZE = 5;
    private static final String DEFAULT_CATEGORY = "en";
    private String conf_file_path = "program-data/textcat/";
    private String conf_file_name = "indoeuropean.conf";
    private ArrayList<TextCategorizerFingerprint> categories = new ArrayList();

    public TextCategorizer() {
        this.loadFingerprints();
    }

    public TextCategorizer(String conf_file_path) {
        this.conf_file_path = conf_file_path;
        this.loadFingerprints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFingerprints() {
        block8: {
            this.categories.clear();
            try {
                BufferedReader reader = new BufferedReader(new FileReader(new File(FileUtils.getApplicationPath() + this.conf_file_path + this.conf_file_name)));
                try {
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        String[] line_arr = line.split("\\s+");
                        if (line_arr.length <= 0) continue;
                        if (line_arr.length != 2) {
                            throw new Exception("Malformed TextCategorizer configuration file.\n\tMust contain one fingerprint file path per line.");
                        }
                        TextCategorizerFingerprint fp = new TextCategorizerFingerprint(FileUtils.getApplicationPath() + this.conf_file_path + line_arr[0], line_arr[1]);
                        this.categories.add(fp);
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block8;
                e.printStackTrace(System.err);
            }
        }
    }

    public String categorize(String text, int limit) {
        if (limit > text.length() - 1) {
            limit = text.length() - 1;
        }
        return this.categorize(text.substring(0, limit));
    }

    public String categorize(String text) {
        if (text.length() < 5) {
            return DEFAULT_CATEGORY;
        }
        TextCategorizerFingerprint fp = new TextCategorizerFingerprint();
        fp.create(text.toLowerCase());
        fp.categorize(this.categories);
        return fp.getCategory();
    }
}

