import argparse

import numpy as np

from more_itertools import flatten

args = argparse.ArgumentParser()

args.add_argument('--tsv', required=True)
args.add_argument('--vocab', required=True)
args.add_argument('--log', action='store_true')

opt = args.parse_args()

with open(opt.tsv) as f:
    data = [l.strip().split() for l in f]

with open(opt.vocab) as f:
    vocab = [l.strip() for l in f]


edge_count = [0] * len(vocab)
for i in flatten(data):
    edge_count[int(i)] += 1

filename = opt.tsv + '.edge'

if opt.log:
    edge_count = [np.log1p(ec) for ec in edge_count]
    filename += '.log'

r_min, r_max = np.min(edge_count), np.max(edge_count)
rs = 2 - (edge_count - r_min) / (r_max - r_min)

with open(filename, 'w') as f:
    for r in rs:
        f.write(f'{r}\n')
