import React, { Component, PureComponent } from 'react';
import { Meteor } from 'meteor/meteor';


function isHighlighted(currentToken, token_id, startSelected, endSelected) {
  if (currentToken == token_id) return true;
  const start = Math.min(endSelected, startSelected);
  const end = Math.max(endSelected, startSelected);
  return start <= token_id && token_id <= end;
}

export default class Token extends Component {
  constructor(props) {
    super(props);

    this.mouseEnter = this.mouseEnter.bind(this);
    this.mouseLeave = this.mouseLeave.bind(this);
    this.mouseDown = this.mouseDown.bind(this);
    this.mouseUp = this.mouseUp.bind(this);
    this.click = this.click.bind(this);
    this.dblclick = this.dblclick.bind(this);
  }

  shouldComponentUpdate(nextProps, nextState) {
    if (this.props.token != nextProps.token) return true;
    if (this.props.ui != nextProps.ui) return true;
    if (this.props.isSelected != nextProps.isSelected) return true;
    if (this.props.depth != nextProps.depth) return true;
    if (this.props.maxDepth != nextProps.maxDepth) return true;
    if (this.props.readOnly != nextProps.readOnly) return true;

    const curH = isHighlighted(this.props.currentToken, this.props.token._id, this.props.startSelected, this.props.endSelected);
    const newH = isHighlighted(nextProps.currentToken, nextProps.token._id, nextProps.startSelected, nextProps.endSelected);
    if (curH != newH) return true;

    return false;
  }

  mouseEnter = (e) => {
    this.props.onMouseEnter(this.props.token._id, e.shiftKey, e.altKey);
  }
  mouseLeave = (e) => {
    this.props.onMouseLeave(this.props.token._id, e.shiftKey, e.altKey);
  }
  mouseDown = (e) => {
    this.props.onMouseDown(this.props.token._id, e.shiftKey, e.altKey);
    e.stopPropagation();
  }
  mouseUp = (e) => {
    this.props.onMouseUp(this.props.token._id, e.shiftKey, e.altKey);
    e.stopPropagation();
  }
  click = (e) => {
    this.props.onClick(this.props.token._id, e.shiftKey, e.altKey);
    e.stopPropagation();
  }
  dblclick = (e) => {
    this.props.onDoubleClick(this.props.token._id, e.shiftKey, e.altKey);
    e.stopPropagation();
  }

  checkHighlighted() {
    return isHighlighted(this.props.currentToken, this.props.token._id, this.props.startSelected, this.props.endSelected);
  }

  getClass() {
    var name = 'noselect token'
    if (this.checkHighlighted()) {
      if (this.props.currentToken == this.props.token._id) {
        name += ' selected';
      } else {
        name += ' highlight';
      }
    } 

    if (
      this.props.readOnly ||
      (this.props.ui.startsWith('check-mentions') && (!this.props.ui.endsWith("editable"))) ||
      (this.props.ui.startsWith('link-to-one') && this.props.depth == 0) ||
      this.props.noPointer
    ) {
      // Do not make it appear clickable
    } else {
      name += ' pointer';
    }

    return name;
  }

  render() {
    const tokenClassName = this.getClass();
    const text = this.props.token.text;

    var divStyle = {};
    if (this.props.isSelected != 'white' && ! this.checkHighlighted()) {
      divStyle = {
        backgroundColor: this.props.isSelected,
        color: 'white'
      };
    } else if (
      this.props.depth > 0 &&
      this.props.backgroundColor != undefined &&
      ! this.checkHighlighted()
    ) {
      divStyle = {
        backgroundColor: this.props.backgroundColor,
      };
    }

    // Add spacing to divStyle based on maxDepth and depth
    const margin = (this.props.maxDepth - this.props.depth) * 2;
    divStyle.marginTop = margin.toString() + "px";

    const coreToken = (text == "\n" || text == "\\n") ?
      [
       <div key="1" className="clear"></div>,
       <span key="3">&nbsp;</span>,
       <div key="2" className="clear"></div>,
      ] : (
        <span 
          className={tokenClassName}
          onMouseEnter={this.mouseEnter}
          onMouseLeave={this.mouseLeave}
          onMouseDown={this.mouseDown}
          onMouseUp={this.mouseUp}
          onClick={this.click}
          onDoubleClick={this.dblclick}
          style={divStyle}
        >{text}</span>
      );

    if (this.props.depth != 0) {
      return coreToken;
    } else {
      return (
        <span
          className="outer-token"
          style={{boxSizing: "border-box", height: this.props.lineHeight.toString() + "px"}}
        >
        {coreToken}
        </span>
      );
    }
  }
}
