/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.trees.AbstractTreebankLanguagePack;
import edu.stanford.nlp.trees.EnglishGrammaticalStructureFactory;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.ModCollinsHeadFinder;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Filter;

public class PennTreebankLanguagePack
extends AbstractTreebankLanguagePack {
    private static String[] pennPunctTags = new String[]{"''", "``", "-LRB-", "-RRB-", ".", ":", ","};
    private static String[] pennSFPunctTags = new String[]{"."};
    private static String[] collinsPunctTags = new String[]{"''", "``", ".", ":", ","};
    private static String[] pennPunctWords = new String[]{"''", "'", "``", "`", "-LRB-", "-RRB-", "-LCB-", "-RCB-", ".", "?", "!", ",", ":", "-", "--", "...", ";"};
    private static String[] pennSFPunctWords = new String[]{".", "!", "?"};
    private static char[] annotationIntroducingChars = new char[]{'-', '=', '|', '#', '^', '~', '_', '['};
    private static String[] pennStartSymbols = new String[]{"ROOT", "TOP"};
    private static final long serialVersionUID = 9081305982861675328L;

    @Override
    public String[] punctuationTags() {
        return pennPunctTags;
    }

    @Override
    public String[] punctuationWords() {
        return pennPunctWords;
    }

    @Override
    public String[] sentenceFinalPunctuationTags() {
        return pennSFPunctTags;
    }

    @Override
    public String[] sentenceFinalPunctuationWords() {
        return pennSFPunctWords;
    }

    @Override
    public String[] evalBIgnoredPunctuationTags() {
        return collinsPunctTags;
    }

    @Override
    public char[] labelAnnotationIntroducingCharacters() {
        return annotationIntroducingChars;
    }

    @Override
    public String[] startSymbols() {
        return pennStartSymbols;
    }

    public TokenizerFactory<CoreLabel> getTokenizerFactory() {
        return PTBTokenizer.coreLabelFactory();
    }

    @Override
    public String treebankFileExtension() {
        return "mrg";
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory() {
        return new EnglishGrammaticalStructureFactory();
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory(Filter<String> puncFilter) {
        return new EnglishGrammaticalStructureFactory(puncFilter);
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory(Filter<String> puncFilter, HeadFinder hf) {
        return new EnglishGrammaticalStructureFactory(puncFilter, hf);
    }

    @Override
    public HeadFinder headFinder() {
        return new ModCollinsHeadFinder(this);
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        return new SemanticHeadFinder((TreebankLanguagePack)this, true);
    }

    public static void main(String[] args) {
        String[] strs;
        PennTreebankLanguagePack tlp = new PennTreebankLanguagePack();
        System.out.println("Start symbol: " + tlp.startSymbol());
        String start = tlp.startSymbol();
        System.out.println("Should be true: " + tlp.isStartSymbol(start));
        for (String str : strs = new String[]{"-", "-LLB-", "NP-2", "NP=3", "NP-LGS", "NP-TMP=3"}) {
            System.out.println("String: " + str + " basic: " + tlp.basicCategory(str) + " basicAndFunc: " + tlp.categoryAndFunction(str));
        }
    }
}

