#ifndef BASELINE_STATUS_H
#define BASELINE_STATUS_H

#include "baseline_macros.h"

namespace baseline {

struct Status {
    tscore score;
    int top_index;
    std::vector< RuleIndex > rule_choices;
    EdgeStateMap edge_states;

    std::bitset< MAX_GRAPH_NODE_COUNT > node_reached;
    std::vector< int > stream_target;

    void reset(int node_count);

    bool operator>(const Status& v) const {
        return score > v.score;
    }

    bool operator<(const Status& v) const {
        return score > v.score;
    }

    void printTree(std::ostream& os, const EdsGraph& graph);
};
}

#endif /* BASELINE_STATUS_H */

// Local Variables:
// mode: c++
// End:
