#include "w2v.ih"

void w2v::loadBin(string const &loc)
{
    d_bin = true;
    cerr << "Loading: " << loc << '\n';
    ifstream ifs(loc, ios::binary);
    if (!ifs.good())
    {
        cerr << "Could not read w2v model: " << loc << '\n';
        exit(1);
    }
    d_vocab.loadBin(&ifs);

    ifs.read(reinterpret_cast<char*>(&d_numCands), sizeof(uint64_t));
    ifs.read(reinterpret_cast<char*>(&d_numWords), sizeof(uint64_t));
    
    d_cands = vector<uint32_t>(d_numWords * d_numCands);
    ifs.read(reinterpret_cast<char*>(&d_cands[0]), sizeof(uint32_t) * d_numWords * d_numCands);
    d_vals = vector<double>(d_numWords * d_numCands);
    ifs.read(reinterpret_cast<char*>(&d_vals[0]), sizeof(double) * d_numWords * d_numCands);
    ifs.close();

    d_resCands = vector<string>(d_numCands);
    d_resVals = vector<double>(d_numCands);
}

