###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

## lmodelbackoff.pl
##   back-off for relations split by category
use Getopt::Std;

getopts('l:'); # will print out M instead of GG

########## OPTIONS
my $lambda = 0.0;
if ($opt_l) {
    $lambda = $opt_l;
    print (STDERR "lambda = $lambda\n");
}
##########


my %Lmix;
my %Lold;
my %Lcat;
my %Cval;
my %Cond;

## for each rule...
while ( <> ) {
    chomp;

    # read in category-split relation
    if ( m/^L ([hm])([^ ]+) (.*) : (.*)( = (.*))?/ ) {
	$Lcat{$1}{$3}{$4}{$2} = defined($5) ? $5 : $Lcat{$1}{$3}{$4}{$2}+1;
	$Cval{$2} = defined($5) ? $5 : $Cval{$2}+1;
	$Cond{"L $1$2 $3"} = defined($5) ? $5 : $Cond{"L $1$2 $3"}+1;
	#print "Lcat  $1$2 $3 : $4 = $Lcat{$1}{$3}{$4}{$2}\n";
    # read in regular relations
    } elsif ( m/^L ([hm]) (.*) : (.*)( = (.*))?/ ) {
	$Lold{$1}{$2}{$3} = defined($4) ? $4 : $Lold{$1}{$2}{$3}+1;
	$Cond{"L $1 $2"} = defined($4) ? $4 : $Cond{"L $1 $2"}+1;
	#print "Lorig $1 $2 : $3 = $4\n";
    }


}

#print join(" ",sort keys %Lold)."\n";
#print join(" ",sort keys %Lcat)."\n";

### look in Lcat for stuff
#foreach $l (sort keys %Lcat) {
#    foreach $c (sort keys %{$Lcat{$l}}) {
#
#	## set Lmix
#	foreach $cond (sort keys %{$Lcat{$l}{$c}}) {
#	    foreach $targ (sort keys %{$Lcat{$l}{$c}{$cond}}) {
#		$Lmix{$l}{$c}{$cond}{$targ} = (1-$lambda) * $Lcat{$l}{$c}{$cond}{$targ} + $lambda * $Lold{$l}{$cond}{$targ};
#		print "L $l$c $cond : $targ = $Lmix{$l}{$c}{$cond}{$targ}\n";
#	    }
#	}
#	##
#
#    }
#}

## fill out the rest of Lmix with Lold
foreach $l (sort keys %Lold) {
    ## set Lmix
    foreach $cond (sort keys %{$Lold{$l}}) {
	foreach $targ (sort keys %{$Lold{$l}{$cond}}) {
	    foreach $c (sort keys %Cval) { #%{$Lcat{$l}{$cond}{$targ}}) {
		#if (! $Lcat{$l}{$c}{$cond}{$targ} && $Lold{$l}{$cond}{$targ}) {
	      #print "L $l$c $cond = ".$Cond{"L $l $cond"}."\n";
		    $Lmix{$l}{$cond}{$targ}{$c} = 
			( (1-$lambda) * $Lcat{$l}{$cond}{$targ}{$c} ) / ($Cond{"L $l$c $cond"}==0?1:$Cond{"L $l$c $cond"}) +
			( $lambda     * $Lold{$l}{$cond}{$targ} ) / $Cond{"L $l $cond"};
		    print "L $l$c $cond : $targ = $Lmix{$l}{$cond}{$targ}{$c}";
		    #print " (from $Lcat{$l}{$cond}{$targ}{$c} $Lold{$l}{$cond}{$targ})";
		    print "\n";
		#}
	    }
	}
    }

} 

#foreach $l (sort keys %Lcat) {
#    foreach $c (sort keys %{$Lcat{$l}}) {
#	## print Lmix
#	foreach $cond (sort keys %{$Lcat{$l}{$c}}) {
#	    foreach $targ (sort keys %{$Lcat{$l}{$c}{$cond}}) {
#	    }
#	}
#    }
#}
