///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>

#include "nl-randvar.h"
#include "nl-dtree.h"
#include "nl-modelfile.h"

static double WEIGHT_THRESHOLD  = 1000; //0.001; //0.01;

////////////////////////////////////////////////////////////////////////////////
//
//  Random Variables
//
////////////////////////////////////////////////////////////////////////////////

//// POS: part of speech category...
DiscreteDomain<short> domainPOS;
typedef DiscreteDomainRV<short, domainPOS> POS;

//// L: letter...
DiscreteDomain<char> domainL;
typedef DiscreteDomainRV<char, domainL> L;

//// W: word (array of letters, arranged last to first)...
//typedef StaticSafeArray<5,L> W;
DiscreteDomain<int> domainW;
class W : public DiscreteDomainRV<int,domainW>, public StaticSafeArray<5,L> {
 public:
  W ( ) { }
  W ( char* ps ) : DiscreteDomainRV<int,domainW>(ps) { char psTemp[2]="-"; int n=strlen(ps);
                                                       for(int i=0;i<5;i++){psTemp[0]=(i<n)?ps[n-i-1]:'_';StaticSafeArray<5,L>::set(i)=L(psTemp);} }
};


////////////////////////////////////////////////////////////////////////////////
//
//  Models
//
////////////////////////////////////////////////////////////////////////////////

TrainableDTree2DModel<POS,W,Prob> modelPOS;

bool readFields ( Array<char*>& aps ) {
  return ( 0==strcmp(aps[0],"PwDT") && modelPOS.readData(aps) );
}

////////////////////////////////////////////////////////////////////////////////
//
//  Main Function (pipe data input)
//
////////////////////////////////////////////////////////////////////////////////

int main (int nArgs, char* argv[]) {

  // Read training data from file...
  cerr << "Reading data...\n";
  clock_t start = clock();
  FILE* pf = (nArgs>1) ? fopen(argv[1],"r") : stdin; 
  assert(pf);
  processModelFilePtr ( pf, readFields );
  clock_t end = clock();
  fprintf ( stderr, "time: %ld ticks or %f seconds\n", end-start, ((double)end - start)/(double)CLOCKS_PER_SEC ) ;

  // Training...
  TrainableDTree2DModel<POS,W,Prob>::OUTPUT_NOISY = true;
  //TrainableDTree2DModel<POS,W,Prob>::OUTPUT_VERYNOISY = true;
  cerr << "Training...\n";
  start = clock();
  modelPOS.train ( WEIGHT_THRESHOLD );
  end = clock();
  fprintf ( stderr, "time: %ld ticks or %f seconds\n", end-start, ((double)end - start)/(double)CLOCKS_PER_SEC ) ;

  // Print model...
  cerr << "Writing...\n";
  modelPOS.writeFields ( stdout, "PwDT" ) ;
}

