import sys
from llama_revision_template import TEMPLATES

tofueval_prompts = {
    "simple_refinement_prompt":"""I summarized the document below, on the topic '{aspect}'
{instruction}

The summary on the '{aspect}' is:
{summary}

If the summary is factually inconsistent, then refine the summary such that it no longer makes those errors. Factual consistency in this context implies that all information presented in the summary is substantiated by the document. If the summary is factually consistent, just say "no error". If the summary is factually inconsistent, the edit the summary such that the refinement doesn't have any errors mentioned in the feedback. Make the minimum number of changes when doing the refinement. 
""",
"simple_feedback_prompt" :"""I summarized the document below, on the topic '{aspect}'
{input}

The summary on the '{aspect}' is:
{summary}

Is the summary factually consistent? Consistency in this context implies that all information presented in the summary is substantiated by the document. If the summary is factually consistent, just say "no error". If the summary is factually inconsistent, then give reasons for the inconsistency and suggest ways to fix summary.
""",
"category_feedback_prompt": """I summarized the document below, on the topic '{aspect}'
{input}

The summary on the '{aspect}' is:
{summary}


Is the summary factually consistent? Consistency in this context implies that all information presented in the summary is substantiated by the document. It can be of the following types:
1. Extrinsic Information: the summary contains new information not grounded in the source document
2. Mis-Referencing: a property or an event in the summary can be found in the document, but are associated with the wrong entity 
3. Stating Opinion As Fact: the summary entails a proposition that's mentioned in the document not as a fact, but as someone's opinion 
4. Reasoning Error: the summary makes one or more wrong inferences from the information in the document
5. Tense/modality Error: the tense or modal (eg: can, may, must) used in the summary does not match the tense/modality of the document
6. Contradiction: the summary contradicts the document
7. Nuanced Meaning Shift: the summary twists information from the document in a subtle way 

Can you identify if the summary is factually consistent? If the summary is factually inconsistent, then give reasons for the inconsistencies, you can identify any inconsistency types based on the list above and suggest ways to fix the summary.
""",
"refinement_with_feedback_prompt":TEMPLATES['tofueval']['prompt'],
"json_category_feedback_prompt":"""Document:
{input}

-----

Can you assess if the summary provided below is factually consistent? Consistency in this context implies that all information presented in the summary is substantiated by the document. It can be of the following types:
1. Extrinsic Information: the summary contains new information not grounded in the source document
2. Mis-Referencing: a property or an event in the summary can be found in the document, but are associated with the wrong entity
3. Stating Opinion As Fact: the summary entails a proposition that's mentioned in the document not as a fact, but as someone's opinion
4. Reasoning Error: the summary makes one or more wrong inferences from the information in the document
5. Tense/modality Error: the tense or modal (eg: can, may, must) used in the summary does not match the tense/modality of the document
6. Contradiction: the summary contradicts the document
7. Nuanced Meaning Shift: the summary twists information from the document in a subtle way

Can you identify if the summary is factually consistent? If the summary is factually consistent then you can simply say "no error" in your response. Otherwise, find inconsistencies in the summary and for each inconsistency identify the inconsistency type and give a feedback that is a helpful and specific suggestion to improve the inconsistency. Give your answer in JSON format only. Do not include a preamble.
{example_output}

-----

Please give feedback on the following summary:

{summary}
""",
}

ultrachat_prompts = {
"simple_refinement_prompt":"""Document:
{instruction}

Response:
{summary}

Can you refine the response to make it more factually consistent? Consistency in this context implies that all information presented in the response is substantiated by the document. If the response is factually consistent, just say "no error". If the response is factually inconsistent, then revise the response with minimal edits.
""",
"simple_feedback_prompt" :"""Document:
{input}

Response:
{summary}

Is the response factually consistent? Consistency in this context implies that all information presented in the response is substantiated by the document. If the response is factually consistent, just say "no error". If the response is factually inconsistent, then give reasons for the inconsistency and suggest ways to fix response.
""",
"category_feedback_prompt": """Document:
{input}

Response:
{summary}


Is the summary factually consistent? Consistency in this context implies that all information presented in the response is substantiated by the document. It can be of the following types:
1. Extrinsic Information: the response contains new information not grounded in the source document
2. Mis-Referencing: a property or an event in the response can be found in the document, but are associated with the wrong entity 
3. Stating Opinion As Fact: the response entails a proposition that's mentioned in the document not as a fact, but as someone's opinion 
4. Reasoning Error: the response makes one or more wrong inferences from the information in the document
5. Tense/modality Error: the tense or modal (eg: can, may, must) used in the response does not match the tense/modality of the document
6. Contradiction: the response contradicts the document
7. Nuanced Meaning Shift: the response twists information from the document in a subtle way 

Can you identify if the response is factually consistent? If the response is factually inconsistent, then give reasons for the inconsistencies, you can identify any inconsistency types based on the list above and suggest ways to fix the response.
""",
"refinement_with_feedback_prompt":TEMPLATES['ultrachat']['prompt'],
"json_category_feedback_prompt":"""Document:
{input}

-----

Can you assess if the summary provided below is factually consistent? Consistency in this context implies that all information presented in the summary is substantiated by the document. It can be of the following types:
1. Extrinsic Information: the summary contains new information not grounded in the source document
2. Mis-Referencing: a property or an event in the summary can be found in the document, but are associated with the wrong entity
3. Stating Opinion As Fact: the summary entails a proposition that's mentioned in the document not as a fact, but as someone's opinion
4. Reasoning Error: the summary makes one or more wrong inferences from the information in the document
5. Tense/modality Error: the tense or modal (eg: can, may, must) used in the summary does not match the tense/modality of the document
6. Contradiction: the summary contradicts the document
7. Nuanced Meaning Shift: the summary twists information from the document in a subtle way

Can you identify if the summary is factually consistent? If the summary is factually consistent then you can simply say "no error" in your response. Otherwise, find inconsistencies in the summary and for each inconsistency identify the inconsistency type and give a feedback that is a helpful and specific suggestion to improve the inconsistency. Give your answer in JSON format only. Do not include a preamble.
{example_output}

-----

Please give feedback on the following summary:

{summary}
""",
}

_example_output_document_text = """Example output:
[
{{
"inconsistency": "<span from the summary with an inconsistency or "None">",
"inconsistency type": <the inconsistency type from the above list of types, e.g. "Extrinsic Information", or "None">,
"feedback": "<explanation why the span has an error and how to fix it, or "None">",
}},
]"""
