theory question_80_3

imports Main

begin

typedecl entity

consts
  Metal :: "entity ⇒ bool"
  ElectricalConductor :: "entity ⇒ bool"
  Material :: "entity ⇒ bool"
  Copper :: "entity ⇒ bool"
  Conducts :: "entity ⇒ entity ⇒ bool"

theorem hypothesis:
  (* Premise: Some materials are electrical conductors. *)
  assumes asm: "Material ma ∧ ElectricalConductor ec"
  (* Hypothesis: Copper is the material that conducts electricity. *)
  shows "∃e. Copper c ∧ Conducts e c"
proof -
  have "ElectricalConductor (Copper c)" using asm(2) explanation_1 by blast
  have "Copper c ⟹ Material c" using explanation_2 by blast
  have "Conducts e c ⟷ ElectricalConductor c" using explanation_4 by blast
  have "Conducts e c" using asm(2) explanation_1 by blast
  then have "∃e. Copper c ∧ Conducts e c" using asm(1) by blast
  then show ?thesis by blast
qed

end
