theory question_85_4

imports Main

begin

typedecl entity

consts
  FlowerCartVendor :: "entity ⇒ bool"
  Vendor :: "entity ⇒ bool"
  SellsFlowers :: "entity ⇒ bool"
  SellsFlowersOnSidewalk :: "entity ⇒ bool"
  FlowerSellerOnSidewalk :: "entity ⇒ bool"
  FlowerSeller :: "entity ⇒ bool"
  OnSidewalk :: "entity ⇒ bool"

(* Explanation 1: For all x, if x is a flower cart vendor, then x is a vendor who sells flowers. *)
axiomatization where
  explanation_1: "∀x. FlowerCartVendor x ⟶ Vendor x ∧ SellsFlowers x"

(* Explanation 2: For all x, x is a vendor who sells flowers on the sidewalk if and only if x is a flower seller on the sidewalk. *)
axiomatization where
  explanation_2: "∀x. (Vendor x ∧ SellsFlowersOnSidewalk x) ⟷ FlowerSellerOnSidewalk x"

(* Explanation 3: For all x, x is a flower cart vendor if and only if x is a flower seller on the sidewalk. *)
axiomatization where
  explanation_3: "∀x. FlowerCartVendor x ⟷ FlowerSellerOnSidewalk x"

theorem hypothesis:
  (* Premise: ∃x. SidewalkFlowerCartVendor(x) *)
  assumes asm: "FlowerCartVendor x"
  (* Hypothesis: ∃x. FlowerSeller(x) ∧ OnSidewalk(x) *)
  shows "∃x. FlowerSellerOnSidewalk x"
proof -
  from asm have "FlowerCartVendor x" by fact
  then have "Vendor x" using explanation_1 by blast
  then have "SellsFlowers x" using explanation_1 by blast
  then have "FlowerSellerOnSidewalk x" using explanation_2 by blast
  then show "∃x. FlowerSellerOnSidewalk x" by blast
qed

end
