theory question_50_10
imports Main

begin

typedecl entity
typedecl event

consts
  DirtBike :: "entity ⇒ bool"
  Vehicle :: "entity ⇒ bool"
  Riding :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Racetrack :: "entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A dirt bike is a type of vehicle. *)
axiomatization where
  explanation_1: "∀x. DirtBike x ⟶ Vehicle x"

(* Explanation 2: An event of riding a vehicle implies the existence of an agent (rider) and a patient (vehicle). *)
axiomatization where
  explanation_2: "∀x y e. Riding e ∧ Agent e x ∧ Patient e y ⟶ Vehicle y ∧ ∃a. Man a ∧ Agent e a"

theorem hypothesis:
  (* Premise: A man riding a dirt bike on a racetrack. *)
  assumes asm: "Man x ∧ DirtBike y ∧ Racetrack z ∧ Riding e ∧ Agent e x ∧ Patient e y ∧ On e z"
  (* Hypothesis: A man is riding a dirt bike. *)
  shows "∃x y e. Man x ∧ DirtBike y ∧ Riding e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Man x ∧ DirtBike y ∧ Riding e ∧ Agent e x ∧ Patient e y" by blast
  then show ?thesis using asm by blast
qed

end
