theory question_87_0

imports Main

begin

typedecl entity
typedecl event

consts
  Tunicates :: "entity ⇒ bool"
  Reproduce :: "event ⇒ bool"
  Sexual :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Bulbs :: "entity ⇒ bool"
  Tunicate :: "entity ⇒ bool"
  NonTunicate :: "entity ⇒ bool"

(* Explanation 1: Tunicates reproduce sexually. *)
axiomatization where
  explanation_1: "∀x. Tunicates x ⟶ (∃e. Reproduce e ∧ Sexual e ∧ Agent e x)"

(* Explanation 2: Bulbs are classified as tunicate or non-tunicate. *)
axiomatization where
  explanation_2: "∀x. Bulbs x ⟶ (Tunicate x ∨ NonTunicate x)"

theorem hypothesis:
  assumes asm: "Bulbs x"
  (* Hypothesis: Bulbs reproduce sexually. *)
  shows "∃e. Reproduce e ∧ Sexual e ∧ Agent e x"
proof -
  from asm have "Bulbs x" by simp
  then have "Tunicate x ∨ NonTunicate x" using explanation_2 by blast
  thus "∃e. Reproduce e ∧ Sexual e ∧ Agent e x" if "Tunicate x"
    for e using explanation_1 by blast
  else
    have "False" by simp
  qed

end
