theory question_81_4

imports Main

begin

typedecl entity
typedecl event

consts
  ExternalMigration :: "entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  Cause :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  SuddenReduction :: "event ⇒ bool"
  InPopulationSize :: "event ⇒ entity ⇒ bool"
  BottleneckEffect :: "event ⇒ bool"
  Occur :: "event ⇒ bool"
  Result :: "event ⇒ event ⇒ bool"

(* Explanation 1: External migration can cause a sudden reduction in the population size of a specific entity. *)
axiomatization where
  explanation_1: "∀x y e1 e2. ExternalMigration x ∧ Entity y ∧ (∃e1. Cause e1 ∧ Agent e1 x ∧ Patient e1 e2) ∧ (∃e2. SuddenReduction e2 ∧ InPopulationSize e2 y ∧ Agent e2 x)"

(* Explanation 2: A sudden reduction in the population size of a specific entity is a necessary condition for the bottleneck effect to occur in that entity. *)
axiomatization where
  explanation_2: "∀x y e. Entity x ∧ SuddenReduction e ∧ InPopulationSize e x ⟶ (∃e1. BottleneckEffect e1 ∧ Occur e1 ∧ Patient e1 x)"

(* Explanation 3: The bottleneck effect is an event that occurs as a result of a sudden reduction in the population size of a specific entity. *)
axiomatization where
  explanation_3: "∀x y e1 e2. Entity x ∧ SuddenReduction e1 ∧ InPopulationSize e1 x ⟶ (∃e2. BottleneckEffect e2 ∧ Occur e2 ∧ Result e2 e1)"

theorem hypothesis:
  assumes asm: "ExternalMigration x"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e. BottleneckEffect e ∧ Occur e ∧  Agent e x ∧ ExternalMigration x "
proof -
  from asm have "ExternalMigration x" by simp
  then obtain e1 where e1: "Cause e1 ∧ Agent e1 x ∧ (∃e2. SuddenReduction e2 ∧ InPopulationSize e2 y)"
    using explanation_1 by blast
  then obtain e2 where e2: "SuddenReduction e2 ∧ InPopulationSize e2 y" by blast
  then have "BottleneckEffect e3 ∧ Occur e3 ∧ Patient e3 y" using explanation_2 by blast
  then obtain e3 where e3: "BottleneckEffect e3 ∧ Occur e3" by blast
  have "Result e3 e2" using explanation_3 e2 by blast
  then have "Agent e3 x" using e1 by blast
  show ?thesis using asm e3 `ExternalMigration x` by blast
qed

end
