theory question_13_0

imports Main

begin

typedecl entity
typedecl event

consts
  Liquid :: "entity ⇒ bool"
  Gas :: "entity ⇒ bool"
  HeatEnergy :: "entity ⇒ bool"
  Change :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Adding :: "event ⇒ bool"
  BoilingEvaporation :: "event ⇒ event ⇒ bool"
  Heat :: "entity ⇒ bool"
  Heating :: "event ⇒ bool"
  Water :: "entity ⇒ bool"
  Disappears :: "event ⇒ bool"
  Probably :: "bool ⇒ bool"
  Evaporated :: "event ⇒ bool"
  Disappeared :: "event ⇒ bool"
  Gone :: "event ⇒ bool"
  StateOfMatter :: "entity ⇒ bool"
  Pan :: "entity ⇒ bool"
  State :: "entity ⇒ bool"
  Changing :: "event ⇒ bool"
  Example :: "event ⇒ event ⇒ bool"

(* Explanation 1: boiling;evaporation means change from a liquid into a gas by adding heat energy. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. Liquid x ∧ Gas y ∧ HeatEnergy z ∧ Change e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Adding e2 ∧ Agent e2 z ∧ Patient e2 x ⟶ BoilingEvaporation e1 e2"

(* Explanation 2: heating means adding heat. *)
axiomatization where
  explanation_2: "∀x y e. Heat x ∧ Heating e ∧ Agent e x ⟶ Adding e"

(* Explanation 3: heat means heat energy. *)
axiomatization where
  explanation_3: "∀x. Heat x ⟶ HeatEnergy x"

(* Explanation 4: water is a kind of liquid. *)
axiomatization where
  explanation_4: "∀x. Water x ⟶ Liquid x"

(* Explanation 5: if a liquid disappears then that liquid probably evaporated. *)
axiomatization where
  explanation_5: "∀x e1 e2. Liquid x ∧ Disappears e1 ∧ Agent e1 x ⟶ Probably (Evaporated e2 ∧ Agent e2 x)"

(* Explanation 6: disappeared is similar to gone. *)
axiomatization where
  explanation_6: "∀e. Disappeared e ⟷ Gone e"

(* Explanation 7: liquid is a kind of state of matter. *)
axiomatization where
  explanation_7: "∀x. Liquid x ⟶ StateOfMatter x"

(* Explanation 8: gas is a kind of state of matter. *)
axiomatization where
  explanation_8: "∀x. Gas x ⟶ StateOfMatter x"

theorem hypothesis:
  assumes asm: "Pan x ∧ Water y ∧ State z ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gone e2 ∧ Agent e2 y"
  (* Hypothesis: Heating a pan of water until the water is all gone is an example of matter changing state. *)
  shows "∃x y z e1 e2 e3. Pan x ∧ Water y ∧ State z ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gone e2 ∧ Agent e2 y ∧ Changing e3 ∧ Agent e3 y ∧ Patient e3 z ∧ Example e1 e3"
proof -
  from asm have "Pan x ∧ Water y ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gone e2 ∧ Agent e2 y" by simp
  then have "Liquid y" using explanation_4 by blast
  then have "HeatEnergy z" using explanation_3 explanation_2 by blast
  then have "Change e1 ∧ Agent e1 y ∧ Patient e1 z" using explanation_1 by blast
  then have "Probably (Evaporated e2 ∧ Agent e2 y)" using explanation_5 by blast
  then have "StateOfMatter y ∧ StateOfMatter z" using explanation_7 explanation_8 by blast
  then have "Changing e3 ∧ Agent e3 y ∧ Patient e3 z" using explanation_1 by blast
  show ?thesis using asm `Changing e3 ∧ Agent e3 y ∧ Patient e3 z` by blast
qed

end
