theory question_20_3

imports Main

begin

typedecl entity
typedecl event

consts
  Fur :: "entity ⇒ bool"
  Mammals :: "entity ⇒ bool"
  Found :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  Has :: "event ⇒ bool"
  Mammal :: "entity ⇒ bool"

(* Explanation 1: Fur is a feature that is found in mammals. *)
axiomatization where
  explanation_1: "∀x y e. Fur x ∧ Mammals y ∧ Found e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: If an entity has fur, it is a mammal. *)
axiomatization where
  explanation_2: "∀x y e. Entity x ∧ Fur y ∧ Has e ∧ Agent e x ∧ Patient e y ⟶ Mammal x"  

theorem hypothesis:
  assumes asm: "Fur x"
  (* Hypothesis: Fur is unique to mammals. *)
  shows "Mammals x"
proof -
  from asm have "Fur x" by simp
  then obtain y e where e: "Mammals y ∧ Found e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then have "Mammal x" using explanation_2 by blast
  show ?thesis using asm `Mammal x` by blast
qed

end
