theory question_20_0

imports Main

begin

typedecl entity
typedecl event

consts
  Hair :: "entity ⇒ bool"
  Fiber :: "entity ⇒ bool"
  Mammals :: "entity ⇒ bool"
  Found :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Fur :: "entity ⇒ bool"

(* Explanation 1: Hair is a fiber that is found only in mammals. *)
axiomatization where
  explanation_1: "∀x y e. Hair x ∧ Fiber x ∧ Mammals y ∧ Found e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: All mammals have fur or hair. *)
axiomatization where
  explanation_2: "∀x. Mammals x ⟶ (Fur x ∨ Hair x)"  

theorem hypothesis:
  assumes asm: "Fur x"
  (* Hypothesis: Fur is unique to mammals. *)
  shows "Mammals x"
proof -
  from asm have "Fur x" by simp
  then have "Mammals x" using explanation_2 by blast
qed

end
