theory question_88_3
imports Main

begin
typedecl entity
typedecl event

consts
  Gymnast :: "entity ⇒ bool"
  Flip :: "event ⇒ bool"
  Skill :: "entity ⇒ bool"
  Does :: "event ⇒ entity ⇒ entity ⇒ bool"
  Displaying :: "event ⇒ entity ⇒ entity ⇒ bool"
  Abilities :: "entity ⇒ bool"
  Show :: "event ⇒ entity ⇒ entity ⇒ bool"
  Skills :: "entity ⇒ bool"
  Displays :: "event ⇒ entity ⇒ entity ⇒ bool"
  Flooring :: "entity ⇒ bool"
  Blue :: "entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"

(* Explanation 1: When a gymnast does a flip, they are displaying a skill. *)
axiomatization where
  explanation_1: "∀x y e1 e2. Gymnast x ∧ Flip e1 ∧ Skill y ∧ Does e1 x y ⟶ Displaying e2 x y"

(* Explanation 2: Displaying a skill is a way for a gymnast to show their abilities. *)
axiomatization where
  explanation_2: "∀x y z e1 e2. Gymnast x ∧ Skill y ∧ Abilities z ∧ Displaying e1 x y ⟶ Show e2 x z"

theorem hypothesis:
  (* Premise: Gymnast does a flip on blue flooring. *)
  assumes asm: "Gymnast x ∧ Flip y ∧ Flooring z ∧ Blue z ∧ Does e x y ∧ On e z"
  (* Hypothesis: A gymnast displays their skills with a flip *)
  shows "∃x y e. Gymnast x ∧ Skills y ∧ Flip e ∧ Displays e x y"
proof -
  from asm have "Gymnast x ∧ Flip y ∧ Does e x y" by blast
  then have "∃e2. Displaying e2 x y" using explanation_1 by blast
  then have "∃e2 z. Show e2 x z" using explanation_2 by blast
  then show ?thesis using asm by blast
qed

end
